<?php

namespace App\Http\Resources\Sales;

use App\Http\Resources\BaseResource;
use Illuminate\Http\Request;

class InvoiceItemResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'description' => $this->description,
            'hsn_code' => $this->hsn_code,
            'quantity' => (float) $this->quantity,
            'uom' => $this->uom,
            'rate' => $this->formatCurrency($this->rate),
            'amount' => $this->formatCurrency($this->amount),
            'tax_rate' => $this->tax_rate,
            'tax_amount' => $this->formatCurrency($this->tax_amount),
        ];
    }
}
