<?php

namespace App\Http\Resources\Purchase;

use App\Http\Resources\BaseResource;
use App\Http\Resources\MasterData\CustomerVendorResource;
use Illuminate\Http\Request;

class PurchaseOrderResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'purchase_order_no' => $this->purchase_order_no,
            'purchase_order_date' => $this->formatDate($this->purchase_order_date),
            'vendor' => new CustomerVendorResource($this->whenLoaded('vendor')),
            'vendor_id' => $this->vendor_name,
            'quotation_no' => $this->quotation_no,
            'quotation_date' => $this->formatDate($this->quotation_date),
            'rfq_no' => $this->rfq_no,
            'rfq_date' => $this->formatDate($this->rfq_date),
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'delivery_date' => $this->formatDate($this->delivery_date),
            'delivery_address' => $this->delivery_address,
            'note' => $this->note,
            'terms_conditions' => $this->terms_conditions,
            'sub_total' => $this->formatCurrency($this->sub_total),
            'discount' => $this->formatCurrency($this->discount),
            'tax_amount' => $this->formatCurrency($this->tax_amount),
            'grand_total' => $this->formatCurrency($this->grand_total),
            'status' => $this->status,
            'status_badge' => $this->getStatusBadge($this->status ?? 'pending'),
            'items' => PurchaseOrderItemResource::collection($this->whenLoaded('items')),
            'grn' => new GrnResource($this->whenLoaded('grn')),
            'has_grn' => $this->whenLoaded('grn', fn() => $this->grn !== null),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }
}
