<?php

namespace App\Http\Resources\Purchase;

use App\Http\Resources\BaseResource;
use Illuminate\Http\Request;

class PurchaseOrderItemResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'material' => $this->material,
            'description' => $this->description,
            'quantity' => (float) $this->quantity,
            'uom' => $this->uom,
            'rate' => $this->formatCurrency($this->rate),
            'amount' => $this->formatCurrency($this->amount),
            'hsn_code' => $this->hsn_code,
            'tax_rate' => $this->tax_rate,
            'tax_amount' => $this->formatCurrency($this->tax_amount),
            'received_qty' => (float) ($this->received_qty ?? 0),
            'pending_qty' => (float) ($this->quantity - ($this->received_qty ?? 0)),
        ];
    }
}
