<?php

namespace App\Http\Resources\Purchase;

use App\Http\Resources\BaseResource;
use Illuminate\Http\Request;

class GrnResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'grn_no' => $this->grn_no,
            'grn_date' => $this->formatDate($this->grn_date),
            'order_no' => $this->order_no,
            'order_date' => $this->formatDate($this->order_date),
            'order_ref_no' => $this->order_ref_no,
            'company_name' => $this->company_name,
            'company_address' => $this->company_address,
            'company_gst' => $this->company_gst,
            'company_phone' => $this->company_phone,
            'company_email' => $this->company_email,
            'quotation_no' => $this->quotation_no,
            'quotation_date' => $this->formatDate($this->quotation_date),
            'rfq_no' => $this->rfq_no,
            'rfq_date' => $this->formatDate($this->rfq_date),
            'part_no' => $this->part_no,
            'project_material_no' => $this->project_material_no,
            'drawing_no' => $this->drawing_no,
            'drawing_rev' => $this->drawing_rev,
            'description' => $this->description,
            'product_type' => $this->product_type,
            'challan_file' => $this->challan_file,
            'has_challan' => !empty($this->challan_file),
            'status' => $this->status,
            'status_badge' => $this->getStatusBadge($this->status ?? 'draft'),
            'products' => GrnProductResource::collection($this->whenLoaded('products')),
            'total_received' => $this->whenLoaded('products', fn() => $this->products->sum('received_qty')),
            'total_accepted' => $this->whenLoaded('products', fn() => $this->products->sum('accepted_qty')),
            'total_rejected' => $this->whenLoaded('products', fn() => $this->products->sum('rejected_qty')),
            'created_at' => $this->formatDateTime($this->created_at),
            'updated_at' => $this->formatDateTime($this->updated_at),
        ];
    }
}
