<?php

namespace App\Http\Resources\Purchase;

use App\Http\Resources\BaseResource;
use Illuminate\Http\Request;

class GrnProductResource extends BaseResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'material' => $this->material,
            'description' => $this->description,
            'ordered_qty' => (float) $this->ordered_qty,
            'received_qty' => (float) $this->received_qty,
            'accepted_qty' => (float) ($this->accepted_qty ?? 0),
            'rejected_qty' => (float) ($this->rejected_qty ?? 0),
            'uom' => $this->uom,
            'remarks' => $this->remarks,
            'inspection_status' => $this->getInspectionStatus(),
        ];
    }

    protected function getInspectionStatus(): array
    {
        $received = (float) $this->received_qty;
        $accepted = (float) ($this->accepted_qty ?? 0);
        $rejected = (float) ($this->rejected_qty ?? 0);

        if ($accepted + $rejected >= $received) {
            if ($rejected > 0 && $accepted == 0) {
                return ['status' => 'rejected', 'class' => 'danger', 'label' => 'Rejected'];
            } elseif ($rejected > 0) {
                return ['status' => 'partial', 'class' => 'warning', 'label' => 'Partial Accept'];
            }
            return ['status' => 'accepted', 'class' => 'success', 'label' => 'Accepted'];
        }
        return ['status' => 'pending', 'class' => 'secondary', 'label' => 'Pending Inspection'];
    }
}
