<?php

namespace App\Http\Requests\Sales;

use App\Http\Requests\BaseFormRequest;

class StoreSalesOrderRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'sales_order_date' => 'required|date',
            'customer_name' => 'required|exists:customer_vendors,id',
            'quotation_no' => 'nullable|string|max:100',
            'quotation_date' => 'nullable|date',
            'po_no' => 'nullable|string|max:100',
            'po_date' => 'nullable|date',
            'part_no' => 'nullable|string|max:100',
            'project_material_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'quantity' => 'required|numeric|min:0.01',
            'quantity_uom' => 'required|string|max:20',
            'description' => 'nullable|string|max:1000',
            'product_type' => 'nullable|string|max:100',
            'delivery_date' => 'nullable|date|after_or_equal:sales_order_date',
            'note' => 'nullable|string|max:2000',
            'sub_total' => 'required|numeric|min:0',
            'discount' => 'nullable|numeric|min:0',
            'tax_amount' => 'nullable|numeric|min:0',
            'grand_total' => 'required|numeric|min:0',
            'status' => 'nullable|in:pending,confirmed,in_production,completed,cancelled',
        ];
    }

    public function attributes(): array
    {
        return [
            'sales_order_date' => 'Sales Order Date',
            'customer_name' => 'Customer',
            'po_no' => 'PO Number',
            'delivery_date' => 'Delivery Date',
        ];
    }

    public function messages(): array
    {
        return [
            'delivery_date.after_or_equal' => 'Delivery date must be on or after the sales order date.',
        ];
    }
}
