<?php

namespace App\Http\Requests\Sales;

use App\Http\Requests\BaseFormRequest;

class StoreRfqRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'rfq_date' => 'required|date',
            'customer_name' => 'required|exists:customer_vendors,id',
            'part_no' => 'nullable|string|max:100',
            'project_material_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'quantity' => 'required|numeric|min:0.01',
            'quantity_uom' => 'required|string|max:20',
            'description' => 'nullable|string|max:1000',
            'product_type' => 'nullable|string|max:100',
            'cust_ref_no' => 'nullable|string|max:100',
            'note' => 'nullable|string|max:2000',
        ];
    }

    public function attributes(): array
    {
        return [
            'rfq_date' => 'RFQ Date',
            'customer_name' => 'Customer',
            'part_no' => 'Part Number',
            'quantity_uom' => 'Unit of Measure',
        ];
    }
}
