<?php

namespace App\Http\Requests\Sales;

use App\Http\Requests\BaseFormRequest;

class StoreQuotationRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'quotation_date' => 'required|date',
            'customer_name' => 'required|exists:customer_vendors,id',
            'rfq_no' => 'nullable|exists:rfqs,id',
            'rfq_date' => 'nullable|date',
            'part_no' => 'nullable|string|max:100',
            'project_material_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'quantity' => 'required|numeric|min:0.01',
            'quantity_uom' => 'required|string|max:20',
            'description' => 'nullable|string|max:1000',
            'product_type' => 'nullable|string|max:100',
            'cust_ref_no' => 'nullable|string|max:100',
            'note' => 'nullable|string|max:2000',
            'sub_total' => 'required|numeric|min:0',
            'discount' => 'nullable|numeric|min:0',
            'round_up' => 'nullable|numeric',
            'grand_total' => 'required|numeric|min:0',
            'raw_materials' => 'nullable|array',
            'raw_materials.*.material' => 'required_with:raw_materials|string',
            'raw_materials.*.quantity' => 'required_with:raw_materials|numeric|min:0',
            'raw_materials.*.rate' => 'required_with:raw_materials|numeric|min:0',
            'raw_materials.*.total' => 'required_with:raw_materials|numeric|min:0',
            'conversion_costs' => 'nullable|array',
            'conversion_costs.*.process' => 'required_with:conversion_costs|string',
            'conversion_costs.*.rate' => 'required_with:conversion_costs|numeric|min:0',
            'conversion_costs.*.total' => 'required_with:conversion_costs|numeric|min:0',
            'packing_charges' => 'nullable|array',
        ];
    }

    public function attributes(): array
    {
        return [
            'quotation_date' => 'Quotation Date',
            'customer_name' => 'Customer',
            'sub_total' => 'Sub Total',
            'grand_total' => 'Grand Total',
        ];
    }
}
