<?php

namespace App\Http\Requests\Sales;

use App\Http\Requests\BaseFormRequest;

class StoreDebitNoteRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'debit_note_no' => 'required|string|max:50|unique:sales_debit_notes,debit_note_no',
            'date' => 'required|date|before_or_equal:today',
            'party_id' => 'required|exists:customer_vendors,id',
            'invoice_no' => 'required|string|max:100',
            'amount' => 'required|numeric|min:0.01|max:99999999.99',
            'reason' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
        ];
    }

    public function attributes(): array
    {
        return [
            'debit_note_no' => 'Debit Note Number',
            'party_id' => 'Customer',
            'invoice_no' => 'Invoice Number',
        ];
    }

    public function messages(): array
    {
        return [
            'date.before_or_equal' => 'Debit note date cannot be in the future.',
            'amount.max' => 'Debit note amount cannot exceed ₹9,99,99,999.99.',
            'debit_note_no.unique' => 'This debit note number already exists.',
            'invoice_no.required' => 'Invoice number is required for debit notes.',
        ];
    }
}
