<?php

namespace App\Http\Requests\Purchase;

use App\Http\Requests\BaseFormRequest;

/**
 * Form request validation for Purchase RFQ
 * Field names match the frontend form submission
 */
class StorePurchaseRfqRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            // Main RFQ fields (matches frontend form names)
            'rfqNo' => 'required|string|unique:purchase_rfqs,rfq_no',
            'rfqDate' => 'required|date',
            'vendor' => 'required|exists:customer_vendors,id',
            'venRefNo' => 'nullable|string|max:100',
            'rfqType' => 'required|string|max:100',
            'description_main' => 'nullable|string|max:2000',
            'deliveryTerms' => 'nullable|string|max:1000',
            'note' => 'nullable|string|max:2000',

            // RFQ Items (array fields)
            'item' => 'nullable|array',
            'item.*' => 'nullable|exists:stock_items,id',
            'description' => 'nullable|array',
            'description.*' => 'nullable|string|max:500',
            'quantity' => 'nullable|array',
            'quantity.*' => 'nullable|numeric|min:0',
            'uom' => 'nullable|array',
            'uom.*' => 'nullable|string|max:20',
            'requiredBy' => 'nullable|array',
            'requiredBy.*' => 'nullable|date',

            // File uploads
            'annexureFiles' => 'nullable|array',
            'annexureFiles.*' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        ];
    }

    public function attributes(): array
    {
        return [
            'rfqNo' => 'RFQ Number',
            'rfqDate' => 'RFQ Date',
            'vendor' => 'Vendor',
            'venRefNo' => 'Vendor Reference Number',
            'rfqType' => 'RFQ Type',
            'deliveryTerms' => 'Delivery Terms',
        ];
    }

    public function messages(): array
    {
        return [
            'rfqNo.unique' => 'This RFQ number already exists.',
            'vendor.exists' => 'The selected vendor does not exist.',
            'annexureFiles.*.max' => 'Each file must not exceed 5MB.',
        ];
    }
}
