<?php

namespace App\Http\Requests\Purchase;

use App\Http\Requests\BaseFormRequest;

class StorePurchaseDebitNoteRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $rules = [
            'debit_note_no' => 'nullable|string|max:50',
            'date' => 'required|date|before_or_equal:today',
            'party_id' => 'required|exists:customer_vendors,id',
            'invoice_no' => 'required|string|max:100',
            'amount' => 'required|numeric|min:0.01|max:99999999.99',
            'reason' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
        ];

        // For store with explicit debit_note_no, it must be unique
        if ($this->isMethod('post') && $this->filled('debit_note_no')) {
            $rules['debit_note_no'] .= '|unique:purchase_debit_notes,debit_note_no';
        }

        return $rules;
    }

    public function attributes(): array
    {
        return [
            'debit_note_no' => 'Debit Note Number',
            'party_id' => 'Vendor',
            'invoice_no' => 'Purchase Invoice Number',
        ];
    }

    public function messages(): array
    {
        return [
            'date.before_or_equal' => 'Debit note date cannot be in the future.',
            'amount.max' => 'Debit note amount cannot exceed ₹9,99,99,999.99.',
            'debit_note_no.unique' => 'This debit note number already exists.',
            'party_id.exists' => 'The selected vendor does not exist.',
        ];
    }
}
