<?php

namespace App\Http\Requests\Purchase;

use App\Http\Requests\BaseFormRequest;

class StorePurchaseCreditNoteRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $rules = [
            'credit_note_no' => 'required|string|max:50',
            'date' => 'required|date|before_or_equal:today',
            'party_id' => 'required|exists:customer_vendors,id',
            'invoice_no' => 'required|string|max:100',
            'amount' => 'required|numeric|min:0.01|max:99999999.99',
            'reason' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
        ];

        // For store, credit_note_no must be unique
        if ($this->isMethod('post')) {
            $rules['credit_note_no'] .= '|unique:credit_notes,credit_note_no';
        }

        return $rules;
    }

    public function attributes(): array
    {
        return [
            'credit_note_no' => 'Credit Note Number',
            'party_id' => 'Vendor',
            'invoice_no' => 'Purchase Invoice Number',
        ];
    }

    public function messages(): array
    {
        return [
            'date.before_or_equal' => 'Credit note date cannot be in the future.',
            'amount.max' => 'Credit note amount cannot exceed ₹9,99,99,999.99.',
            'credit_note_no.unique' => 'This credit note number already exists.',
            'party_id.exists' => 'The selected vendor does not exist.',
        ];
    }
}
