<?php

namespace App\Http\Requests\Purchase;

use App\Http\Requests\BaseFormRequest;

class StoreGrnRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'grn_date' => 'required|date',
            'order_no' => 'required|string|max:100',
            'order_date' => 'nullable|date',
            'order_ref_no' => 'nullable|string|max:100',
            'company_name' => 'required|string|max:255',
            'company_address' => 'nullable|string|max:500',
            'company_gst' => 'nullable|string|max:20',
            'company_phone' => 'nullable|string|max:20',
            'company_email' => 'nullable|email|max:100',
            'quotation_no' => 'nullable|string|max:100',
            'quotation_date' => 'nullable|date',
            'rfq_no' => 'nullable|string|max:100',
            'rfq_date' => 'nullable|date',
            'part_no' => 'nullable|string|max:100',
            'project_material_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'description' => 'nullable|string|max:1000',
            'product_type' => 'nullable|string|max:100',
            'challan_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            'status' => 'nullable|in:draft,received,inspected,accepted,rejected',
            'products' => 'required|array|min:1',
            'products.*.material' => 'required|string',
            'products.*.ordered_qty' => 'required|numeric|min:0',
            'products.*.received_qty' => 'required|numeric|min:0',
            'products.*.accepted_qty' => 'nullable|numeric|min:0',
            'products.*.rejected_qty' => 'nullable|numeric|min:0',
            'products.*.uom' => 'required|string|max:20',
            'products.*.remarks' => 'nullable|string|max:500',
        ];
    }

    public function attributes(): array
    {
        return [
            'grn_date' => 'GRN Date',
            'order_no' => 'Order Number',
            'company_name' => 'Company Name',
            'company_gst' => 'GST Number',
            'challan_file' => 'Challan File',
            'products.*.material' => 'Material',
            'products.*.ordered_qty' => 'Ordered Quantity',
            'products.*.received_qty' => 'Received Quantity',
        ];
    }

    public function messages(): array
    {
        return [
            'products.required' => 'At least one product is required.',
            'products.min' => 'At least one product is required.',
            'challan_file.max' => 'Challan file must not exceed 5MB.',
        ];
    }
}
