<?php

namespace App\Http\Requests\MasterData;

use App\Http\Requests\BaseFormRequest;

class StoreMachineRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $id = $this->route('id') ?? $this->route('machine');

        return [
            'machine_code' => 'required|string|max:50|unique:machines,machine_code,' . $id,
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'category' => 'nullable|string|max:100',
            'make' => 'nullable|string|max:100',
            'model' => 'nullable|string|max:100',
            'serial_no' => 'nullable|string|max:100',
            'purchase_date' => 'nullable|date',
            'warranty_expiry' => 'nullable|date|after:purchase_date',
            'location' => 'nullable|string|max:100',
            'capacity' => 'nullable|string|max:100',
            'power_rating' => 'nullable|string|max:50',
            'hourly_rate' => 'nullable|numeric|min:0',
            'maintenance_schedule' => 'nullable|string|max:500',
            'last_maintenance' => 'nullable|date',
            'next_maintenance' => 'nullable|date',
            'status' => 'nullable|in:active,inactive,under_maintenance,retired',
        ];
    }

    public function attributes(): array
    {
        return [
            'machine_code' => 'Machine Code',
            'serial_no' => 'Serial Number',
            'purchase_date' => 'Purchase Date',
            'warranty_expiry' => 'Warranty Expiry',
            'hourly_rate' => 'Hourly Rate',
            'last_maintenance' => 'Last Maintenance Date',
            'next_maintenance' => 'Next Maintenance Date',
        ];
    }
}
