<?php

namespace App\Http\Requests\MasterData;

use App\Http\Requests\BaseFormRequest;

class StoreCustomerVendorRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $id = $this->route('id') ?? $this->route('customer');

        return [
            'company' => 'required|string|max:255',
            'company_role' => 'required|in:Customer,Vendor,Both',
            'company_type' => 'nullable|string|max:100',
            'account_type' => 'nullable|string|max:100',
            'address' => 'nullable|string|max:500',
            'city' => 'nullable|string|max:100',
            'state' => 'nullable|string|max:100',
            'pincode' => 'nullable|string|max:10',
            'country' => 'nullable|string|max:100',
            'gst' => 'nullable|string|max:20',
            'pan' => 'nullable|string|max:20',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:100',
            'website' => 'nullable|url|max:200',
            'credit_limit' => 'nullable|numeric|min:0',
            'payment_terms' => 'nullable|string|max:100',
            'bank_name' => 'nullable|string|max:100',
            'bank_account_no' => 'nullable|string|max:50',
            'ifsc_code' => 'nullable|string|max:20',
            'status' => 'nullable|in:active,inactive',
            'contacts' => 'nullable|array',
            'contacts.*.name' => 'required_with:contacts|string|max:100',
            'contacts.*.designation' => 'nullable|string|max:100',
            'contacts.*.phone' => 'nullable|string|max:20',
            'contacts.*.email' => 'nullable|email|max:100',
            'contacts.*.is_primary' => 'nullable|boolean',
        ];
    }

    public function attributes(): array
    {
        return [
            'company' => 'Company Name',
            'company_role' => 'Company Role',
            'company_type' => 'Company Type',
            'account_type' => 'Account Type',
            'gst' => 'GST Number',
            'pan' => 'PAN Number',
            'credit_limit' => 'Credit Limit',
            'bank_account_no' => 'Bank Account Number',
            'ifsc_code' => 'IFSC Code',
        ];
    }
}
