<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;
use App\Models\RouteCardProcess;

class UpdateRouteCardProcessRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'process' => 'sometimes|required|string|max:100',
            'machine' => 'nullable|exists:machines,id',
            'operator' => 'nullable|exists:employee_details,id',
            'cycle_hours' => 'nullable|integer|min:0',
            'cycle_minutes' => 'nullable|integer|min:0|max:59',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'status' => 'nullable|in:' . implode(',', RouteCardProcess::getStatuses()),
            'description' => 'nullable|string|max:500',
            'source' => 'nullable|string|max:100',
            'previous_process_id' => 'nullable|exists:route_card_processes,id',
        ];
    }

    public function attributes(): array
    {
        return [
            'process' => 'Process Name',
            'machine' => 'Machine',
            'operator' => 'Operator',
            'cycle_hours' => 'Cycle Time Hours',
            'cycle_minutes' => 'Cycle Time Minutes',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'previous_process_id' => 'Previous Process',
        ];
    }

    public function messages(): array
    {
        return [
            'end_date.after_or_equal' => 'End date must be on or after the start date.',
            'cycle_minutes.max' => 'Cycle time minutes cannot exceed 59.',
            'status.in' => 'Invalid process status.',
        ];
    }
}
