<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;

class StoreSkuRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'sku_code' => 'required|string|max:100|unique:sku_masters,sku_code',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'category' => 'nullable|string|max:100',
            'part_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'uom' => 'required|string|max:20',
            'min_stock' => 'nullable|numeric|min:0',
            'max_stock' => 'nullable|numeric|min:0',
            'reorder_level' => 'nullable|numeric|min:0',
            'location' => 'nullable|string|max:100',
            'status' => 'nullable|in:active,inactive',
        ];
    }

    public function attributes(): array
    {
        return [
            'sku_code' => 'SKU Code',
            'uom' => 'Unit of Measure',
            'min_stock' => 'Minimum Stock',
            'max_stock' => 'Maximum Stock',
            'reorder_level' => 'Reorder Level',
        ];
    }

    public function messages(): array
    {
        return [
            'sku_code.unique' => 'This SKU code already exists.',
        ];
    }
}
