<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;
use App\Models\SkuApproval;

class StoreSkuApprovalRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'customer_id' => 'required|exists:customer_vendors,id',
            'items' => 'required|array|min:1',
            'items.*' => 'required|exists:skumaster,id',
            'date' => 'required|date',
            'status' => 'nullable|in:' . implode(',', SkuApproval::getStatuses()),
            'stock_status' => 'nullable|in:' . implode(',', SkuApproval::getStockStatuses()),
        ];
    }

    public function attributes(): array
    {
        return [
            'customer_id' => 'Customer',
            'items' => 'SKU Items',
            'items.*' => 'SKU Item',
            'date' => 'Approval Date',
            'stock_status' => 'Stock Status',
        ];
    }

    public function messages(): array
    {
        return [
            'customer_id.required' => 'Customer is required.',
            'customer_id.exists' => 'Selected customer does not exist.',
            'items.required' => 'At least one SKU item is required.',
            'items.min' => 'At least one SKU item is required.',
            'items.*.exists' => 'One or more selected SKU items do not exist.',
            'date.required' => 'Approval date is required.',
        ];
    }
}
