<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;

class StoreRouteCardRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'sales_order_id' => 'required|exists:sales_orders,id',
            'start_date' => 'required|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'part_no' => 'nullable|string|max:100',
            'drawing_no' => 'nullable|string|max:100',
            'drawing_rev' => 'nullable|string|max:50',
            'quantity' => 'required|numeric|min:0.01',
            'description' => 'nullable|string|max:1000',
            'priority' => 'nullable|in:low,normal,high,urgent',
            'status' => 'nullable|in:pending,in_progress,completed,on_hold,cancelled',
            'remarks' => 'nullable|string|max:2000',
            'processes' => 'required|array|min:1',
            'processes.*.process' => 'required|string|max:100',
            'processes.*.machine' => 'nullable|exists:machines,id',
            'processes.*.operator' => 'nullable|exists:employee_details,id',
            'processes.*.cycle_hours' => 'nullable|integer|min:0',
            'processes.*.cycle_minutes' => 'nullable|integer|min:0|max:59',
            'processes.*.start_date' => 'nullable|date',
            'processes.*.end_date' => 'nullable|date',
            'processes.*.description' => 'nullable|string|max:500',
        ];
    }

    public function attributes(): array
    {
        return [
            'sales_order_id' => 'Sales Order',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'processes.*.process' => 'Process Name',
            'processes.*.machine' => 'Machine',
            'processes.*.operator' => 'Operator',
        ];
    }

    public function messages(): array
    {
        return [
            'processes.required' => 'At least one process is required.',
            'processes.min' => 'At least one process is required.',
            'end_date.after_or_equal' => 'End date must be on or after the start date.',
        ];
    }
}
