<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;
use App\Models\QcApproval;

class StoreQcApprovalRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'process_id' => 'required|exists:route_card_processes,id',
            'level' => 'required|integer|in:' . implode(',', array_keys(QcApproval::getLevels())),
            'stage' => 'required|in:' . implode(',', QcApproval::getStages()),
            'status' => 'nullable|in:' . implode(',', QcApproval::getStatuses()),
            'remarks' => 'nullable|string|max:2000',
            'parameters' => 'nullable|array',
            'parameters.*.name' => 'required_with:parameters|string|max:100',
            'parameters.*.value' => 'required_with:parameters|string|max:255',
            'parameters.*.result' => 'nullable|in:pass,fail,na',
        ];
    }

    public function attributes(): array
    {
        return [
            'process_id' => 'Process',
            'level' => 'Approval Level',
            'stage' => 'QC Stage',
            'parameters.*.name' => 'Parameter Name',
            'parameters.*.value' => 'Parameter Value',
        ];
    }

    public function messages(): array
    {
        return [
            'process_id.required' => 'Process is required for QC approval.',
            'process_id.exists' => 'Selected process does not exist.',
            'level.required' => 'Approval level is required.',
            'stage.required' => 'QC stage (before/during/after) is required.',
        ];
    }
}
