<?php

namespace App\Http\Requests\Manufacturing;

use App\Http\Requests\BaseFormRequest;
use App\Models\ManufacturingPlan;

class StoreManufacturingPlanRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'rc_id' => 'required|exists:route_cards,id',
            'company_name' => 'nullable|string|max:255',
            'status' => 'nullable|in:' . implode(',', ManufacturingPlan::getStatuses()),
            'rc_date' => 'nullable|date',
            'plan_date' => 'nullable|date',
            'machine' => 'nullable|exists:machines,id',
            'process' => 'nullable|string|max:100',
            'operator' => 'nullable|exists:employee_details,id',
            'ct_hours' => 'nullable|integer|min:0',
            'ct_minutes' => 'nullable|integer|min:0|max:59',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
        ];
    }

    public function attributes(): array
    {
        return [
            'rc_id' => 'Route Card',
            'company_name' => 'Company Name',
            'ct_hours' => 'Cycle Time Hours',
            'ct_minutes' => 'Cycle Time Minutes',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
        ];
    }

    public function messages(): array
    {
        return [
            'rc_id.required' => 'Route Card is required.',
            'rc_id.exists' => 'Selected Route Card does not exist.',
            'end_date.after_or_equal' => 'End date must be on or after the start date.',
            'ct_minutes.max' => 'Cycle time minutes cannot exceed 59.',
        ];
    }
}
