<?php

namespace App\Http\Requests\Inventory;

use App\Http\Requests\BaseFormRequest;
use App\Models\StockItem;

class StoreStockItemRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $id = $this->route('id') ?? $this->route('stockItem');

        return [
            'category_id' => 'required|exists:categories,id',
            'item_name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'uom' => 'nullable|string|max:50',
            'quantity' => 'nullable|numeric|min:0',
            'min_stock' => 'nullable|numeric|min:0',
            'max_stock' => 'nullable|numeric|min:0',
            'sgst' => 'nullable|numeric|min:0|max:100',
            'cgst' => 'nullable|numeric|min:0|max:100',
            'igst' => 'nullable|numeric|min:0|max:100',
            'hsn_code' => 'nullable|string|max:20',
            'status' => 'nullable|in:' . implode(',', StockItem::getStatuses()),
        ];
    }

    public function attributes(): array
    {
        return [
            'category_id' => 'Category',
            'item_name' => 'Item Name',
            'description' => 'Description',
            'uom' => 'Unit of Measure',
            'quantity' => 'Quantity',
            'min_stock' => 'Minimum Stock',
            'max_stock' => 'Maximum Stock',
            'sgst' => 'SGST',
            'cgst' => 'CGST',
            'igst' => 'IGST',
            'hsn_code' => 'HSN Code',
        ];
    }

    public function messages(): array
    {
        return [
            'category_id.required' => 'Please select a category.',
            'category_id.exists' => 'Selected category does not exist.',
            'item_name.required' => 'Item name is required.',
            'quantity.min' => 'Quantity cannot be negative.',
            'min_stock.min' => 'Minimum stock cannot be negative.',
            'sgst.max' => 'SGST cannot exceed 100%.',
            'cgst.max' => 'CGST cannot exceed 100%.',
            'igst.max' => 'IGST cannot exceed 100%.',
        ];
    }
}
