<?php

namespace App\Http\Requests\Inventory;

use App\Http\Requests\BaseFormRequest;
use App\Models\RawMaterial;

class StoreRawMaterialRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $id = $this->route('id') ?? $this->route('rawmaterial');

        return [
            'name' => 'required|string|max:255',
            'rm_grade' => 'nullable|string|max:255',
            'iso_specification' => 'nullable|string|max:255',
            'density' => 'nullable|numeric|min:0',
            'raw_material_type' => 'nullable|string|max:100',
            'mechanical_properties' => 'nullable|string',
            'chemical_properties' => 'nullable|string',
            'quantity' => 'nullable|numeric|min:0',
            'min_stock' => 'nullable|numeric|min:0',
            'uom' => 'nullable|string|max:50',
            'status' => 'nullable|in:' . implode(',', RawMaterial::getStatuses()),
            'product_type_id' => 'nullable|exists:product_types,id',
            'files' => 'nullable|array',
            'files.*' => 'file|mimes:pdf,doc,docx,jpg,jpeg,png|max:10240',
        ];
    }

    public function attributes(): array
    {
        return [
            'name' => 'Material Name',
            'rm_grade' => 'RM Grade',
            'iso_specification' => 'ISO Specification',
            'density' => 'Density',
            'raw_material_type' => 'Material Type',
            'mechanical_properties' => 'Mechanical Properties',
            'chemical_properties' => 'Chemical Properties',
            'quantity' => 'Quantity',
            'min_stock' => 'Minimum Stock',
            'uom' => 'Unit of Measurement',
            'product_type_id' => 'Product Type',
            'files.*' => 'File',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'Material name is required.',
            'density.numeric' => 'Density must be a number.',
            'density.min' => 'Density cannot be negative.',
            'quantity.min' => 'Quantity cannot be negative.',
            'min_stock.min' => 'Minimum stock cannot be negative.',
            'files.*.mimes' => 'Files must be PDF, DOC, DOCX, JPG, JPEG, or PNG.',
            'files.*.max' => 'Each file must not exceed 10MB.',
        ];
    }
}
