<?php

namespace App\Http\Requests\Employee;

use App\Http\Requests\BaseFormRequest;

class StoreEmployeeRequest extends BaseFormRequest
{
    public function rules(): array
    {
        $employeeId = $this->route('id') ?? $this->route('employee');

        return [
            'employee_code' => 'required|string|max:50|unique:employee_details,employee_code,' . $employeeId,
            'first_name' => 'required|string|max:100',
            'last_name' => 'nullable|string|max:100',
            'email' => 'nullable|email|max:100|unique:employee_details,email,' . $employeeId,
            'phone' => 'nullable|string|max:20',
            'alternate_phone' => 'nullable|string|max:20',
            'date_of_birth' => 'nullable|date|before:today',
            'gender' => 'nullable|in:male,female,other',
            'marital_status' => 'nullable|in:single,married,divorced,widowed',
            'blood_group' => 'nullable|string|max:10',
            'address' => 'nullable|string|max:500',
            'city' => 'nullable|string|max:100',
            'state' => 'nullable|string|max:100',
            'pincode' => 'nullable|string|max:10',
            'department' => 'nullable|string|max:100',
            'designation' => 'nullable|string|max:100',
            'date_of_joining' => 'required|date',
            'date_of_leaving' => 'nullable|date|after:date_of_joining',
            'reporting_to' => 'nullable|exists:employee_details,id',
            'employment_type' => 'nullable|in:permanent,contract,probation,intern',
            'shift' => 'nullable|string|max:50',
            'bank_name' => 'nullable|string|max:100',
            'bank_account_no' => 'nullable|string|max:50',
            'ifsc_code' => 'nullable|string|max:20',
            'pan_no' => 'nullable|string|max:20',
            'aadhar_no' => 'nullable|string|max:20',
            'pf_no' => 'nullable|string|max:50',
            'esi_no' => 'nullable|string|max:50',
            'basic_salary' => 'nullable|numeric|min:0',
            'status' => 'nullable|in:active,inactive,terminated',
            'photo' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
        ];
    }

    public function attributes(): array
    {
        return [
            'employee_code' => 'Employee Code',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'date_of_birth' => 'Date of Birth',
            'date_of_joining' => 'Date of Joining',
            'date_of_leaving' => 'Date of Leaving',
            'reporting_to' => 'Reporting Manager',
            'bank_account_no' => 'Bank Account Number',
            'ifsc_code' => 'IFSC Code',
            'pan_no' => 'PAN Number',
            'aadhar_no' => 'Aadhar Number',
            'pf_no' => 'PF Number',
            'esi_no' => 'ESI Number',
        ];
    }
}
