<?php

namespace App\Http\Requests\Employee;

use App\Http\Requests\BaseFormRequest;

class StoreAttendanceRequest extends BaseFormRequest
{
    public function rules(): array
    {
        return [
            'employee_id' => 'required|exists:employee_details,id',
            'attendance_date' => 'required|date',
            'check_in' => 'nullable|date_format:H:i',
            'check_out' => 'nullable|date_format:H:i|after:check_in',
            'status' => 'required|in:present,absent,half_day,late,on_leave,holiday,week_off',
            'overtime_hours' => 'nullable|numeric|min:0|max:24',
            'remarks' => 'nullable|string|max:500',
            'shift' => 'nullable|string|max:50',
            'work_location' => 'nullable|string|max:100',
        ];
    }

    public function attributes(): array
    {
        return [
            'employee_id' => 'Employee',
            'attendance_date' => 'Attendance Date',
            'check_in' => 'Check In Time',
            'check_out' => 'Check Out Time',
            'overtime_hours' => 'Overtime Hours',
        ];
    }

    public function messages(): array
    {
        return [
            'check_out.after' => 'Check out time must be after check in time.',
        ];
    }
}
