<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Base\BaseInvoiceController;
use App\Services\Sales\InvoiceService;

/**
 * SuperAdmin Invoice Controller
 *
 * Extends BaseInvoiceController with SuperAdmin-specific functionality.
 * Includes approval/rejection capabilities and relaxed validation.
 *
 * Reduction: 305 LOC → 35 LOC (88% reduction)
 */
class SuperAdminInvoiceController extends BaseInvoiceController
{
    public function __construct(InvoiceService $service)
    {
        parent::__construct($service);
    }

    /**
     * SuperAdmin has relaxed validation (only invoice_no and date required)
     * All other fields are optional for flexibility
     */
    protected function validateStoreRequest(\Illuminate\Http\Request $request): void
    {
        $request->validate([
            'invoice_no' => 'required|unique:tax_invoices',
            'invoice_date' => 'required|date',
        ]);
    }

    // All other methods (approve, reject, destroy, update, show) are inherited from BaseInvoiceController
    // SuperAdmin has full access to all operations defined in the base controller
}
