<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\ConversionProcess;
use Illuminate\Http\Request;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

class SuperAdminConversionProcessController extends Controller
{
    public function index()
    {
        return view('superadmin.master.conversion_processes');
    }

    public function list()
    {
        $processes = ConversionProcess::all();
        return response()->json(['data' => $processes]);
    }
    
    public function show($id)
    {
        $process = ConversionProcess::findOrFail($id);
        return response()->json($process);
    }

    public function store_old(Request $request)
    {
        $request->validate([
            'process_name' => 'required|string|max:255',
        ]);

        $process = ConversionProcess::create($request->all());

        return response()->json(['success' => true, 'message' => 'Process added successfully']);
    }
    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'process_name' => 'required|string|max:255|unique:conversion_processes,process_name',
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed.',
                'errors' => $validator->errors(),
            ], 422);
        }
    
        ConversionProcess::create([
            'process_name' => $request->process_name,
        ]);
    
        return response()->json(['success' => true, 'message' => 'Process added successfully']);
    }
    
    public function update_old(Request $request, $id)
    {
        $request->validate([
            'process_name' => 'required|string|max:255',
        ]);

        $process = ConversionProcess::findOrFail($id);
        $process->update($request->all());

        return response()->json(['success' => true, 'message' => 'Process updated successfully']);
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'process_name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('conversion_processes', 'process_name')->ignore($id)
            ],
        ]);
    
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed.',
                'errors' => $validator->errors(),
            ], 422);
        }
    
        $process = ConversionProcess::findOrFail($id);
    
        $process->update([
            'process_name' => $request->process_name,
        ]);
    
        return response()->json(['success' => true, 'message' => 'Process updated successfully']);
    }

    public function destroy($id)
    {
        $process = ConversionProcess::findOrFail($id);
        $process->delete();

        return response()->json(['success' => true, 'message' => 'Process deleted successfully']);
    }
}
