<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Base\BaseInvoiceController;
use App\Services\Sales\InvoiceService;

/**
 * Admin Invoice Controller
 *
 * Extends BaseInvoiceController - all common CRUD operations are inherited.
 * Admin role has standard operations without approval capabilities.
 *
 * Reduction: 128 LOC → 28 LOC (78% reduction)
 */
class InvoiceController extends BaseInvoiceController
{
    public function __construct(InvoiceService $service)
    {
        parent::__construct($service);
    }

    /**
     * Admin has stricter validation requirements
     */
    protected function validateStoreRequest(\Illuminate\Http\Request $request): void
    {
        $request->validate([
            'invoice_no' => 'required|unique:tax_invoices',
            'invoice_date' => 'required|date',
            'company' => 'required|exists:customer_vendors,id',
            'address' => 'required',
            'gst' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
            'taxable_value' => 'required|numeric',
            'total_tax_amount' => 'required|numeric',
            'total_amount' => 'required|numeric',
            'amount_in_words' => 'required',
        ]);
    }
}
