<?php

namespace App\Http\Controllers\Modules\Manufacturing;

use App\Http\Controllers\Controller;
use App\Http\Traits\HasRoleViews;
use App\Models\RouteCard;
use App\Models\ManufacturingPlan;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

/**
 * Unified Project Planning Controller
 *
 * Handles project planning view (Gantt chart visualization).
 * This is primarily a view-only feature that displays
 * manufacturing plans and route cards in a Gantt chart format.
 *
 * Note: This controller replaces the legacy role-specific controllers:
 * - Admin/ProjectPlanningController
 * - Manager/ManagerProjectPlanningController
 * - SuperAdmin/SuperAdminProjectPlanningController
 */
class ProjectPlanningController extends Controller
{
    use HasRoleViews;

    /**
     * Display the project planning page (Gantt chart view)
     */
    public function index()
    {
        return $this->roleView('projectplanning.projectplanning');
    }

    /**
     * Get project data for Gantt chart (AJAX)
     */
    public function getData(): JsonResponse
    {
        $routeCards = RouteCard::with(['processes' => function ($q) {
            $q->orderBy('start_date');
        }])->orderBy('project_start_date')->get();

        $projects = [];
        foreach ($routeCards as $rc) {
            $projects[] = [
                'id' => $rc->id,
                'name' => $rc->route_no,
                'company' => $rc->company_name,
                'status' => $rc->status,
                'start_date' => $rc->project_start_date,
                'end_date' => $rc->route_date,
                'processes_count' => $rc->processes->count(),
            ];
        }

        return response()->json(['data' => $projects]);
    }
}
