<?php

namespace App\Events\Sales;

use App\Events\BaseEvent;
use App\Models\SalesOrder;

class SalesOrderStatusChanged extends BaseEvent
{
    public SalesOrder $salesOrder;
    public string $previousStatus;
    public string $newStatus;

    public function __construct(SalesOrder $salesOrder, string $previousStatus, string $newStatus)
    {
        parent::__construct();
        $this->salesOrder = $salesOrder;
        $this->previousStatus = $previousStatus;
        $this->newStatus = $newStatus;
    }
}
