<?php

namespace App\Events\Sales;

use App\Events\BaseEvent;
use App\Models\SalesOrder;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class SalesOrderCreated extends BaseEvent
{
    public SalesOrder $salesOrder;

    public function __construct(SalesOrder $salesOrder)
    {
        parent::__construct();
        $this->salesOrder = $salesOrder;
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('sales-orders'),
        ];
    }
}
