<?php

namespace App\Events\Sales;

use App\Events\BaseEvent;
use App\Models\TaxInvoice;

class PaymentReceived extends BaseEvent
{
    public TaxInvoice $invoice;
    public float $amount;
    public string $paymentMethod;
    public ?string $referenceNo;

    public function __construct(TaxInvoice $invoice, float $amount, string $paymentMethod, ?string $referenceNo = null)
    {
        parent::__construct();
        $this->invoice = $invoice;
        $this->amount = $amount;
        $this->paymentMethod = $paymentMethod;
        $this->referenceNo = $referenceNo;
    }
}
