<?php

namespace App\Events\Purchase;

use App\Events\BaseEvent;
use App\Models\PurchaseOrder;

class PurchaseOrderApproved extends BaseEvent
{
    public PurchaseOrder $purchaseOrder;
    public ?string $remarks;

    public function __construct(PurchaseOrder $purchaseOrder, ?string $remarks = null)
    {
        parent::__construct();
        $this->purchaseOrder = $purchaseOrder;
        $this->remarks = $remarks;
    }
}
