<?php

namespace App\Events\Manufacturing;

use App\Events\BaseEvent;
use App\Models\QcApproval;
use App\Models\RouteCardProcess;

class QcApprovalCompleted extends BaseEvent
{
    public RouteCardProcess $process;
    public QcApproval $qcApproval;
    public string $stage;
    public string $status;

    public function __construct(RouteCardProcess $process, QcApproval $qcApproval, string $stage, string $status)
    {
        parent::__construct();
        $this->process = $process;
        $this->qcApproval = $qcApproval;
        $this->stage = $stage;
        $this->status = $status;
    }
}
