<?php

namespace App\Events\Manufacturing;

use App\Events\BaseEvent;
use App\Models\RouteCardProcess;

class ProcessStatusChanged extends BaseEvent
{
    public RouteCardProcess $process;
    public string $previousStatus;
    public string $newStatus;

    public function __construct(RouteCardProcess $process, string $previousStatus, string $newStatus)
    {
        parent::__construct();
        $this->process = $process;
        $this->previousStatus = $previousStatus;
        $this->newStatus = $newStatus;
    }
}
