<?php

namespace App\Events\Inventory;

use App\Events\BaseEvent;

class StockLevelLow extends BaseEvent
{
    public string $itemType;
    public int $itemId;
    public string $itemName;
    public float $currentStock;
    public float $minimumStock;
    public float $reorderLevel;

    public function __construct(
        string $itemType,
        int $itemId,
        string $itemName,
        float $currentStock,
        float $minimumStock,
        float $reorderLevel
    ) {
        parent::__construct();
        $this->itemType = $itemType;
        $this->itemId = $itemId;
        $this->itemName = $itemName;
        $this->currentStock = $currentStock;
        $this->minimumStock = $minimumStock;
        $this->reorderLevel = $reorderLevel;
    }
}
