<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

/**
 * Base Event
 *
 * Provides common functionality for all events.
 */
abstract class BaseEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * The user who triggered the event
     */
    public ?int $userId;

    /**
     * Timestamp when the event was triggered
     */
    public string $triggeredAt;

    /**
     * Create a new event instance.
     */
    public function __construct()
    {
        $this->userId = auth()->id();
        $this->triggeredAt = now()->toIso8601String();
    }

    /**
     * Get the event name
     */
    public function getEventName(): string
    {
        return class_basename(static::class);
    }
}
