<div class="modal fade" id="addItemModal" tabindex="-1" role="dialog" aria-labelledby="addItemModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addItemModalLabel">Add New Item</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addItemForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-stock-item" class="form-label">Stock Item *</label>
                                <select name="stock_item" id="modal-stock-item" class="form-control selectpicker"
                                    data-live-search="true" data-width="100%" required
                                    onchange="getStockItemDetails(this)">
                                    <option value="">Select Stock Item</option>
                                    @foreach ($stockItems as $stockItem)
                                        <option value="{{ $stockItem->id }}"
                                            data-stock-item-name="{{ $stockItem->item_name }}">{{ $stockItem->item_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-supply-lead-time" class="form-label">Supply Lead Time</label>
                                <input type="text" class="form-control" id="modal-supply-lead-time">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="modal-description" class="form-label">Description</label>
                                <textarea class="form-control" id="modal-description" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-quantity" class="form-label">Quantity *</label>
                                <input type="number" class="form-control" id="modal-quantity" step="1" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-uom" class="form-label">UOM</label>
                                <input type="text" class="form-control" id="modal-uom" value="Nos">
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-unit-rate" class="form-label">Unit Rate (INR) *</label>
                                <input type="number" class="form-control" id="modal-unit-rate" step="1" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-discount" class="form-label">Discount (%)</label>
                                <input type="number" class="form-control" id="modal-discount" step="0.01">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="modal-tds" class="form-label">TDS (%)</label>
                                <input type="number" class="form-control" id="modal-tds" step="0.01">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="modal-sgst" class="form-label">SGST (%)</label>
                                <input type="number" class="form-control" id="modal-sgst" step="0.01">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="modal-cgst" class="form-label">CGST (%)</label>
                                <input type="number" class="form-control" id="modal-cgst" step="0.01">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modal-igst" class="form-label">IGST (%)</label>
                                <input type="number" class="form-control" id="modal-igst" step="0.01">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Calculated Values</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <small class="text-muted">Value (INR):</small>
                                        <div id="modal-calculated-value" class="form-control-plaintext">0.00</div>
                                    </div>
                                    <div class="col-md-6">
                                        <small class="text-muted">Amount (INR):</small>
                                        <div id="modal-calculated-amount" class="form-control-plaintext">0.00</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="addItemBtn">Add Item</button>
            </div>
        </div>
    </div>
</div>
<script>
    function getStockItemDetails(select) {
        // Function can be used for future enhancements like auto-filling description/price
    }
    // Modal calculation function
    function calculateModalValues() {
        var quantity = parseFloat(document.getElementById('modal-quantity').value) || 0;
        var unitRate = parseFloat(document.getElementById('modal-unit-rate').value) || 0;
        var tdsPercent = parseFloat(document.getElementById('modal-tds').value) || 0;
        var discountPercent = parseFloat(document.getElementById('modal-discount').value) || 0;
        var sgstPercent = parseFloat(document.getElementById('modal-sgst').value) || 0;
        var cgstPercent = parseFloat(document.getElementById('modal-cgst').value) || 0;
        var igstPercent = parseFloat(document.getElementById('modal-igst').value) || 0;

        var value = quantity * unitRate;
        var discount = value * discountPercent / 100;
        var sgst = (value - discount) * sgstPercent / 100;
        var cgst = (value - discount) * cgstPercent / 100;
        var igst = (value - discount) * igstPercent / 100;
        var tds = value * tdsPercent / 100;
        var amount = (value - discount) + sgst + cgst + igst - tds;

        document.getElementById('modal-calculated-value').textContent = value.toFixed(2);
        document.getElementById('modal-calculated-amount').textContent = amount.toFixed(2);
    }

    function addItemRow(item) {
        const {
            stockItem,
            stockItemName,
            description,
            quantity,
            uom,
            supplyLeadTime,
            unitRate,
            tds,
            discount,
            sgst,
            cgst,
            igst,
            amount,
            value
        } = item;

        var tbody = document.getElementById('poItemsBody');
        var rowCount = tbody.querySelectorAll('tr').length;

        // Create new row
        let rowHtml = `<tr><td>${rowCount + 1}</td>`;
        // Create stock item dropdown HTML
        let stockItemOptions = '<option value="">Select Stock Item</option>';
        @foreach ($stockItems as $si)
            stockItemOptions += `<option value="{{ $si->id }}" ${stockItem == "{{ $si->id }}" ? 'selected' : ''}>{{ $si->item_name }}</option>`;
        @endforeach
        
        rowHtml +=
            `<td>
            <select name="items[${rowCount}][stock_item]" class="form-control stock-item-select selectpicker" data-live-search="true" data-width="100%">
                ${stockItemOptions}
            </select>
        </td>`;
        rowHtml +=
            `<td><textarea name="items[${rowCount}][description]" class="form-control" rows="1">${description}</textarea></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" value="${quantity}" /></td>`;
        rowHtml +=
            `<td><input type="text" name="items[${rowCount}][uom]" class="form-control" value="${uom}" /></td>`;
        rowHtml +=
            `<td><input type="text" name="items[${rowCount}][supply_lead_time]" class="form-control" value="${supplyLeadTime}" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][unit_rate]" class="form-control unit-rate" value="${unitRate}" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][tds]" class="form-control tds" value="${tds}" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][discount]" class="form-control discount" value="${discount}" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][value]" class="form-control value" value="${parseFloat(value).toFixed(2)}" readonly /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][sgst]" class="form-control sgst" value="${sgst}" step="0.01" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][cgst]" class="form-control cgst" value="${cgst}" step="0.01" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][igst]" class="form-control igst" value="${igst}" step="0.01" /></td>`;
        rowHtml +=
            `<td><input type="number" name="items[${rowCount}][amount]" class="form-control amount" value="${parseFloat(amount).toFixed(2)}" readonly /></td>`;
        rowHtml +=
            `<td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)"><i class="fa fa-trash"></i></button></td></tr>`;

        tbody.insertAdjacentHTML('beforeend', rowHtml);
        
        // Initialize selectpicker for the newly added row
        const newRow = tbody.lastElementChild;
        $(newRow).find('.selectpicker').selectpicker();

        // Trigger update event
        const event = new CustomEvent('update');
        document.getElementById('pqoItems').dispatchEvent(event);
    }

    document.getElementById('pqoItems').addEventListener('row-added', function(event) {
        const item = event.detail;
        addItemRow(item);
    });

    document.getElementById('addItemBtn').addEventListener('click', function() {
        var form = document.getElementById('addItemForm');
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }
        
        // Get modal values
        var stockItemSelect = document.getElementById('modal-stock-item');
        var stockItem = stockItemSelect.value;
        var stockItemName = stockItemSelect.options[stockItemSelect.selectedIndex].dataset.stockItemName || '';
        var description = document.getElementById('modal-description').value;
        var quantity = document.getElementById('modal-quantity').value;
        var uom = document.getElementById('modal-uom').value;
        var supplyLeadTime = document.getElementById('modal-supply-lead-time').value;
        var unitRate = document.getElementById('modal-unit-rate').value;
        var tds = document.getElementById('modal-tds').value;
        var discount = document.getElementById('modal-discount').value;
        var sgst = document.getElementById('modal-sgst').value;
        var cgst = document.getElementById('modal-cgst').value;
        var igst = document.getElementById('modal-igst').value;

        // Calculate values
        var value = parseFloat(quantity) * parseFloat(unitRate);
        var discountAmount = value * (parseFloat(discount) || 0) / 100;
        var sgstAmount = (value - discountAmount) * (parseFloat(sgst) || 0) / 100;
        var cgstAmount = (value - discountAmount) * (parseFloat(cgst) || 0) / 100;
        var igstAmount = (value - discountAmount) * (parseFloat(igst) || 0) / 100;
        var amount = (value - discountAmount) + sgstAmount + cgstAmount + igstAmount;

        addItemRow({
            stockItem,
            stockItemName,
            description,
            quantity,
            uom,
            supplyLeadTime,
            unitRate,
            tds,
            discount,
            sgst,
            cgst,
            igst,
            amount,
            value
        });

        // Clear modal and close
        document.getElementById('addItemForm').reset();
        document.getElementById('modal-calculated-value').textContent = '0.00';
        document.getElementById('modal-calculated-amount').textContent = '0.00';
        // Close modal (Bootstrap 4)
        $('#addItemModal').modal('hide');
    });

    
    
    // Modal input listeners for real-time calculation
    ['modal-quantity', 'modal-unit-rate', 'modal-tds', 'modal-discount', 'modal-sgst', 'modal-cgst', 'modal-igst']
    .forEach(function(inputId) {
        document.getElementById(inputId).addEventListener('input', calculateModalValues);
    });
</script>
