<?php
    // Helper function to check if current route matches any of the given patterns
    $isActiveMenu = function($patterns) {
        foreach ((array)$patterns as $pattern) {
            if (request()->routeIs($pattern) || request()->is($pattern)) {
                return true;
            }
        }
        return false;
    };

    // Define menu active states
    $dashboardActive = $isActiveMenu([
        'superadmin.dashboard.*',
        'superadmin/dashboard',
        'superadmin/employeedashboard',
        'superadmin/machinedashboard',
        'superadmin/stockdashboard',
        'superadmin/accountdashboard',
        'superadmin/manufactingdashboard'
    ]);

    $userActive = $isActiveMenu([
        'superadmin.users.*',
        'superadmin/users/*'
    ]);

    $masterActive = $isActiveMenu([
        'superadmin.companytype.*',
        'superadmin.accounttype.*',
        'superadmin.rfqtype.*',
        'superadmin.producttype.*',
        'superadmin.rawmaterial.*',
        'superadmin.conversionprocess.*',
        'superadmin.process.*',
        'superadmin.stockitems.*'
    ]);

    $crmActive = $isActiveMenu([
        'superadmin.customer.*',
        'superadmin/customer/*'
    ]);

    $salesActive = $isActiveMenu([
        'superadmin.salesbom.*',
        'superadmin.sales.*',
        'superadmin.invoice.*',
        'superadmin.salesmanagement.*',
        'superadmin/sales/*',
        'superadmin/invoice/*'
    ]);

    $purchaseActive = $isActiveMenu([
        'superadmin.purchasebom.*',
        'superadmin.purchasequotation.*',
        'superadmin.purchase.*',
        'superadmin.purchaseorder.*',
        'superadmin/purchase/*'
    ]);

    $operationActive = $isActiveMenu([
        'superadmin.grn.*',
        'superadmin.routecard.*',
        'superadmin/grn/*',
        'superadmin/routecard/*'
    ]);

    $planningActive = $isActiveMenu([
        'superadmin.manufacturing.*',
        'superadmin.production.*',
        'superadmin/ready-to-production*',
        'superadmin/quality/*',
        'superadmin/manufacturing/*'
    ]);

    $skuMachinesActive = $isActiveMenu([
        'superadmin.sku.*',
        'superadmin.machine.*',
        'superadmin/skuapprovals*',
        'superadmin/sku/*',
        'superadmin/machine/*'
    ]);

    $hrmActive = $isActiveMenu([
        'superadmin.employee.*',
        'superadmin/employee*',
        'superadmin/employeepayroll*',
        'superadmin/employeeleave*',
        'superadmin/employeeattendance*',
        'superadmin/employeedailyreports*'
    ]);

    $reportsActive = $isActiveMenu([
        'superadmin.report.*',
        'superadmin/report/*'
    ]);

    $activityActive = $isActiveMenu([
        'superadmin.activity.*',
        'superadmin/activity*'
    ]);

    $accountsActive = $isActiveMenu([
        'superadmin.accounts.*',
        'superadmin/accounts/*'
    ]);
?>

<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="#">
        <div class="sidebar-brand-icon rotate-n-15">
            <img src="<?php echo e(asset('img/logo-sm.png')); ?>">
        </div>
        <div class="sidebar-brand-text mx-3">Indus Pro 360</div>
    </a>

    <hr class="sidebar-divider my-0">

    <!-- Dashboard -->
    <li class="nav-item <?php echo e($dashboardActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($dashboardActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseDashboard"
            aria-expanded="<?php echo e($dashboardActive ? 'true' : 'false'); ?>" aria-controls="collapseDashboard">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>
        <div id="collapseDashboard" class="collapse <?php echo e($dashboardActive ? 'show' : ''); ?>" aria-labelledby="headingDashboard" data-parent="#accordionSidebar">
            <div class="bg-light py-2 collapse-inner rounded">
                <h6 class="collapse-header">Dashboard</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.dashboard')); ?>">Dashboard</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.empoyeedashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.empoyeedashboard')); ?>">Employee Dashboard</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.machinedashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.machinedashboard')); ?>">Machine Dashboard</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.stockdashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.stockdashboard')); ?>">Stock Dashboard</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.accountdashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.accountdashboard')); ?>">Account Dashboard</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.dashboard.manufacturingdashboard') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.dashboard.manufacturingdashboard')); ?>">Manufacturing Dashboard</a>
            </div>
        </div>
    </li>

    <hr class="sidebar-divider">

    <!-- User Management -->
    <li class="nav-item <?php echo e($userActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($userActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseUser"
            aria-expanded="<?php echo e($userActive ? 'true' : 'false'); ?>" aria-controls="collapseUser">
            <i class="fas fa-fw fa-users"></i>
            <span>User Management</span>
        </a>
        <div id="collapseUser" class="collapse <?php echo e($userActive ? 'show' : ''); ?>" aria-labelledby="headingUser" data-parent="#accordionSidebar">
            <div class="bg-light py-2 collapse-inner rounded">
                <h6 class="collapse-header">Manage User's</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.users.userdetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.users.userdetails')); ?>">User Details</a>
            </div>
        </div>
    </li>

    <hr class="sidebar-divider">

    <!-- Master Management -->
    <li class="nav-item <?php echo e($masterActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($masterActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseMaster"
            aria-expanded="<?php echo e($masterActive ? 'true' : 'false'); ?>" aria-controls="collapseMaster">
            <i class="fas fa-fw fa-check-square"></i>
            <span>Master</span>
        </a>
        <div id="collapseMaster" class="collapse <?php echo e($masterActive ? 'show' : ''); ?>" aria-labelledby="headingMaster" data-parent="#accordionSidebar">
            <div class="bg-light py-2 collapse-inner rounded">
                <h6 class="collapse-header">Manage Data</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.companytype.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.companytype.index')); ?>">Company Types</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounttype.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounttype.index')); ?>">Account Types</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.rfqtype.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.rfqtype.index')); ?>">RFQ Types</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.producttype.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.producttype.index')); ?>">Product Type</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.rawmaterial.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.rawmaterial.index')); ?>">Raw Materials</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.conversionprocess.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.conversionprocess.index')); ?>">Conversion Costs</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.process.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.process.index')); ?>">Production Processes</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.stockitems.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.stockitems.index')); ?>">Stock Items</a>
            </div>
        </div>
    </li>

    <hr class="sidebar-divider">

    <!-- Accounts Management -->
    <!-- Accounts Management -->
    <li class="nav-item <?php echo e($accountsActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($accountsActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseAccounts"
            aria-expanded="<?php echo e($accountsActive ? 'true' : 'false'); ?>" aria-controls="collapseAccounts">
            <i class="fas fa-fw fa-calculator"></i>
            <span>Accounts Management</span>
        </a>
        <div id="collapseAccounts" class="collapse <?php echo e($accountsActive ? 'show' : ''); ?>" aria-labelledby="headingAccounts" data-parent="#accordionSidebar">
            <div class="bg-light py-2 collapse-inner rounded">
                <h6 class="collapse-header">Payables & Receivables</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounts.payable.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounts.payable.index')); ?>">Accounts Payable</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounts.receivable.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounts.receivable.index')); ?>">Accounts Receivable</a>
                <h6 class="collapse-header">Financial Reports</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounts.reports.balance-sheet') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounts.reports.balance-sheet')); ?>">Balance Sheet</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounts.reports.profit-loss') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounts.reports.profit-loss')); ?>">Profit & Loss</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.accounts.reports.cash-flow') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.accounts.reports.cash-flow')); ?>">Cash Flow</a>
            </div>
        </div>
    </li>

    <hr class="sidebar-divider">


    <!-- CRM -->
    <li class="nav-item <?php echo e($crmActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($crmActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseCRM"
            aria-expanded="<?php echo e($crmActive ? 'true' : 'false'); ?>" aria-controls="collapseCRM">
            <i class="fas fa-fw fa-folder"></i>
            <span>CRM</span>
        </a>
        <div id="collapseCRM" class="collapse <?php echo e($crmActive ? 'show' : ''); ?>" aria-labelledby="headingCRM" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Customer Relationship Management</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.customer.addcustomer') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.customer.addcustomer')); ?>">Customer/Vendor Registration</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.customer.customerlist') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.customer.customerlist')); ?>">Customer/Vendor Management</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- Sales -->
    <li class="nav-item <?php echo e($salesActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($salesActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseSales"
            aria-expanded="<?php echo e($salesActive ? 'true' : 'false'); ?>" aria-controls="collapseSales">
            <i class="fas fa-fw fa-cog"></i>
            <span>Sales BOM</span>
        </a>
        <div id="collapseSales" class="collapse <?php echo e($salesActive ? 'show' : ''); ?>" aria-labelledby="headingSales" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Sales BOM</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salesbom.rfq.rfq') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salesbom.rfq.rfq')); ?>">Request For Quotation</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salesbom.rfq.rfqdetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salesbom.rfq.rfqdetails')); ?>">RFQ Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salesbom.quotation.quotationorder') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salesbom.quotation.quotationorder')); ?>">Quotation</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salesbom.quotation.quotationdetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salesbom.quotation.quotationdetails')); ?>">Quotation Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.sales.salesorder') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.sales.salesorder')); ?>">Sales Order</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.sales.salesdetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.sales.salesdetails')); ?>">Sales Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.invoice.invoiceorder') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.invoice.invoiceorder')); ?>">Sales Invoice</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.invoice.invoicedetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.invoice.invoicedetails')); ?>">Sales Invoice Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salesmanagement.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salesmanagement.index')); ?>">Sales Management</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- Purchase -->
    <li class="nav-item <?php echo e($purchaseActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($purchaseActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapsePurchase"
            aria-expanded="<?php echo e($purchaseActive ? 'true' : 'false'); ?>" aria-controls="collapsePurchase">
            <i class="fas fa-fw fa-cog"></i>
            <span>Purchase BOM</span>
        </a>
        <div id="collapsePurchase" class="collapse <?php echo e($purchaseActive ? 'show' : ''); ?>" aria-labelledby="headingPurchase" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Purchase BOM</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchasebom.rfq.rfq') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchasebom.rfq.rfq')); ?>">Request For Quotation</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchasebom.rfq.rfqdetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchasebom.rfq.rfqdetails')); ?>">RFQ Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchasequotation.index') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchasequotation.index')); ?>">Purchase Quotation</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchasequotation.list') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchasequotation.list')); ?>">Purchase Quotation Details</a>

                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchase.purchaseorder') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchase.purchaseorder')); ?>">Purchase Order</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchase.purchasedetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchase.purchasedetails')); ?>">Purchase Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.purchase.accounts') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.purchase.accounts')); ?>">Vendor Accounts</a>
                <!--<a class="collapse-item" href="<?php echo e(route('superadmin.purchaseorder.create')); ?>">Purchase Order</a>-->
                <!--<a class="collapse-item" href="<?php echo e(route('superadmin.purchaseorder.index')); ?>">Purchase Order Details</a>-->
                <!-- Purchase Invoice (V1) - Disabled -->
                <!-- <a class="collapse-item" href="#">Purchase Invoice</a> -->
            </div>
        </div>
    </li>

    <hr class="sidebar-divider">

    <!-- Operation -->
    <li class="nav-item <?php echo e($operationActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($operationActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseOperation"
            aria-expanded="<?php echo e($operationActive ? 'true' : 'false'); ?>" aria-controls="collapseOperation">
            <i class="fas fa-fw fa-folder"></i>
            <span>Operation</span>
        </a>
        <div id="collapseOperation" class="collapse <?php echo e($operationActive ? 'show' : ''); ?>" aria-labelledby="headingOperation" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Operation</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.grn.grnorder') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.grn.grnorder')); ?>">Goods Received Note</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.grn.grndetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.grn.grndetails')); ?>">GRN Data Management</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.routecard.index') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.routecard.index')); ?>">Route Card</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.routecard.details') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.routecard.details')); ?>">Route Card Data Management</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- Planning -->
    <li class="nav-item <?php echo e($planningActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($planningActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapsePlanning"
            aria-expanded="<?php echo e($planningActive ? 'true' : 'false'); ?>" aria-controls="collapsePlanning">
            <i class="fas fa-fw fa-folder"></i>
            <span>Manufacturing Process</span>
        </a>
        <div id="collapsePlanning" class="collapse <?php echo e($planningActive ? 'show' : ''); ?>" aria-labelledby="headingPlanning" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Manufacturing</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.manufacturing.planning') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.manufacturing.planning')); ?>">Manufacturing Planning</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/ready-to-production*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/ready-to-production')); ?>">Ready For Production</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.production.inprogress.list') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.production.inprogress.list')); ?>">Production Management</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/quality/*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/quality/qc-management')); ?>">Quality Control</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- SKU and Machines -->
    <li class="nav-item <?php echo e($skuMachinesActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($skuMachinesActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseskumachines"
            aria-expanded="<?php echo e($skuMachinesActive ? 'true' : 'false'); ?>" aria-controls="collapseskumachines">
            <i class="fas fa-fw fa-folder"></i>
            <span>SKU & Machines</span>
        </a>
        <div id="collapseskumachines" class="collapse <?php echo e($skuMachinesActive ? 'show' : ''); ?>" aria-labelledby="headingOperation" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Stock Keeping Unit And Machines</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.sku.skumaster') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.sku.skumaster')); ?>">SKU Master</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/skuapprovals*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/skuapprovals')); ?>">SKU Approvals</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.sku.skumovement') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.sku.skumovement')); ?>">SKU Movement</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.machine.addmachine') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.machine.addmachine')); ?>">Add Machine</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.machine.machinedetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.machine.machinedetails')); ?>">Machine Data Management</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- HRM -->
    <li class="nav-item <?php echo e($hrmActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($hrmActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseHRM"
            aria-expanded="<?php echo e($hrmActive ? 'true' : 'false'); ?>" aria-controls="collapseHRM">
            <i class="fas fa-fw fa-wrench"></i>
            <span>HRM</span>
        </a>
        <div id="collapseHRM" class="collapse <?php echo e($hrmActive ? 'show' : ''); ?>" aria-labelledby="headingHRM" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Human Resource Management</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.salary-structure.index') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.salary-structure.index')); ?>">Salary Structure Master</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.holiday.index') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.holiday.index')); ?>">Holiday Master</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.employee.employeedetails') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.employee.employeedetails')); ?>">Employee Details</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/employeepayroll*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/employeepayroll')); ?>">Employee Salary</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/employeeleave*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/employeeleave')); ?>">Employee Leave</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/employeeattendance*') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/employeeattendance')); ?>">Attendance</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/employeedailyreports') && !request()->is('superadmin/employeedailyreports/calendarview') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/employeedailyreports')); ?>">Daily Report</a>
                <a class="collapse-item <?php echo e(request()->is('superadmin/employeedailyreports/calendarview') ? 'active' : ''); ?>" href="<?php echo e(url('superadmin/employeedailyreports/calendarview')); ?>">Calendar View</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- All Reports -->
    <li class="nav-item <?php echo e($reportsActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($reportsActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseReports"
            aria-expanded="<?php echo e($reportsActive ? 'true' : 'false'); ?>" aria-controls="collapseReports">
            <i class="fas fa-fw fa-folder"></i>
            <span>All Reports</span>
        </a>
        <div id="collapseReports" class="collapse <?php echo e($reportsActive ? 'show' : ''); ?>" aria-labelledby="headingReports" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Reports</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.report.employeereport') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.report.employeereport')); ?>">Employee Report</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.report.machinereport') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.report.machinereport')); ?>">Machine Report</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.report.inventoryreport') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.report.inventoryreport')); ?>">Inventory Report</a>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.report.customerreport') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.report.customerreport')); ?>">Customer Report</a>
                
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.report.billreport') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.report.billreport')); ?>">Bill Report</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- System -->
    <li class="nav-item <?php echo e($activityActive ? 'active' : ''); ?>">
        <a class="nav-link <?php echo e($activityActive ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseSystem"
            aria-expanded="<?php echo e($activityActive ? 'true' : 'false'); ?>" aria-controls="collapseSystem">
            <i class="fas fa-fw fa-cogs"></i>
            <span>System</span>
        </a>
        <div id="collapseSystem" class="collapse <?php echo e($activityActive ? 'show' : ''); ?>" aria-labelledby="headingSystem" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">System Management</h6>
                <a class="collapse-item <?php echo e(request()->routeIs('superadmin.activity.*') ? 'active' : ''); ?>" href="<?php echo e(route('superadmin.activity.index')); ?>">User Activity Log</a>
            </div>
        </div>
    </li>
    <hr class="sidebar-divider">

    <!-- Sidebar Toggler -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>
</ul>
<?php /**PATH D:\xampp\htdocs\induspro\resources\views/partials/superadminsidebar.blade.php ENDPATH**/ ?>