<!-- Topbar -->
<nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

    <!-- Sidebar Toggle (Topbar) -->
    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
        <i class="fa fa-bars"></i>
    </button>

    <!-- Topbar Navbar -->
    <ul class="navbar-nav ml-auto">

        <div class="topbar-divider d-none d-sm-block"></div>

        <!-- Nav Item - User Information -->
        <li class="nav-item dropdown no-arrow">
            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <?php if(auth()->guard()->check()): ?>
                    <span class="mr-2 d-none d-lg-inline text-gray-600 small">
                        <?php echo e(Auth::user()->name); ?>

                    </span>
                    <img class="img-profile rounded-circle" src="<?php echo e(Auth::user()->profile_photo_url ?? asset('img/undraw_profile.svg')); ?>">
                <?php else: ?>
                    <span class="mr-2 d-none d-lg-inline text-gray-600 small">Guest</span>
                    <img class="img-profile rounded-circle" src="<?php echo e(asset('img/undraw_profile.svg')); ?>">
                <?php endif; ?>
            </a>
            <!-- Dropdown - User Information -->
            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                aria-labelledby="userDropdown">
                <?php if(auth()->guard()->check()): ?>
                    <?php
                        $userRole = Auth::user()->role ?? 'guest';
                        $profileRoute = '#';

                        if ($userRole === 'superadmin' && Route::has('superadmin.profile.index')) {
                            $profileRoute = route('superadmin.profile.index');
                        } elseif ($userRole === 'manager' && Route::has('manager.profile.index')) {
                            $profileRoute = route('manager.profile.index');
                        } elseif ($userRole === 'admin' && Route::has('admin.profile.index')) {
                            $profileRoute = route('admin.profile.index');
                        }
                    ?>
                    <a class="dropdown-item" href="<?php echo e($profileRoute); ?>">
                        <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                        Profile
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                        Logout
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                <?php else: ?>
                    <a class="dropdown-item" href="<?php echo e(route('login')); ?>">
                        <i class="fas fa-sign-in-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                        Login
                    </a>
                <?php endif; ?>
            </div>
        </li>
    </ul>
</nav>
<!-- End of Topbar -->
<?php /**PATH D:\xampp\htdocs\induspro\resources\views/partials/topbar.blade.php ENDPATH**/ ?>