

<?php $__env->startSection('title', 'Holiday Master'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .dataTables_wrapper .dt-buttons {
        float: left;
        margin-right: 10px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Holiday Master</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<!-- Holidays Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-calendar-alt mr-2"></i> Holiday List
        </h6>
        <button class="btn btn-light btn-sm" id="addHolidayBtn">
            <i class="fas fa-plus mr-1"></i> Add Holiday
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm" id="holidayTable" width="100%" cellspacing="0">
                <thead class="thead-light">
                    <tr>
                        <th>Date</th>
                        <th>Day</th>
                        <th>Holiday Name</th>
                        <th>Type</th>
                        <th>Description</th>
                        <th width="100" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr id="row-<?php echo e($holiday->id); ?>">
                            <td><?php echo e(\Carbon\Carbon::parse($holiday->date)->format('d-m-Y')); ?></td>
                            <td><?php echo e($holiday->day); ?></td>
                            <td><?php echo e($holiday->name); ?></td>
                            <td>
                                <?php if($holiday->type == 'Public Holiday'): ?>
                                    <span class="badge badge-success">Public Holiday</span>
                                <?php else: ?>
                                    <span class="badge badge-info"><?php echo e($holiday->type); ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($holiday->description); ?></td>
                            <td class="text-center">
                                <button class="btn btn-warning btn-sm edit-btn" 
                                    data-id="<?php echo e($holiday->id); ?>"
                                    data-name="<?php echo e($holiday->name); ?>"
                                    data-date="<?php echo e($holiday->date); ?>"
                                    data-type="<?php echo e($holiday->type); ?>"
                                    data-description="<?php echo e($holiday->description); ?>">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-sm delete-btn" data-id="<?php echo e($holiday->id); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add/Edit Holiday Modal -->
<div class="modal fade" id="holidayModal" tabindex="-1" role="dialog" aria-labelledby="holidayModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="holidayForm" method="POST" action="<?php echo e(route('superadmin.holiday.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" id="formMethod" value="POST">
                <div class="modal-header" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                    <h5 class="modal-title text-white" id="holidayModalLabel">
                        <i class="fas fa-plus-circle mr-2"></i> Add Holiday
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="small font-weight-bold">Holiday Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" id="name" required>
                    </div>
                    <div class="form-group">
                        <label class="small font-weight-bold">Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="date" id="date" required>
                    </div>
                    <div class="form-group">
                        <label class="small font-weight-bold">Type <span class="text-danger">*</span></label>
                        <select class="form-control" name="type" id="type" required>
                            <option value="Public Holiday">Public Holiday</option>
                            <option value="Optional Holiday">Optional Holiday</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="small font-weight-bold">Description</label>
                        <textarea class="form-control" name="description" id="description" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary btn-sm">Save Holiday</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    $('#holidayTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });

    $('#addHolidayBtn').on('click', function() {
        $('#holidayForm')[0].reset();
        $('#formMethod').val('POST');
        $('#holidayForm').attr('action', '<?php echo e(route("superadmin.holiday.store")); ?>');
        $('#holidayModalLabel').html('<i class="fas fa-plus-circle mr-2"></i> Add Holiday');
        $('#holidayModal').modal('show');
    });

    $('.edit-btn').on('click', function() {
        const id = $(this).data('id');
        const name = $(this).data('name');
        const date = $(this).data('date');
        const type = $(this).data('type');
        const desc = $(this).data('description');

        $('#name').val(name);
        $('#date').val(date);
        $('#type').val(type);
        $('#description').val(desc);

        $('#formMethod').val('PUT');
        $('#holidayForm').attr('action', '<?php echo e(url("/superadmin/holiday")); ?>/' + id);
        $('#holidayModalLabel').html('<i class="fas fa-edit mr-2"></i> Edit Holiday');
        $('#holidayModal').modal('show');
    });

    $('.delete-btn').on('click', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "This holiday will be deleted!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo e(url("/superadmin/holiday")); ?>/' + id,
                    type: 'DELETE',
                    headers: {'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'},
                    success: function(res) {
                        $('#row-' + id).remove();
                        Swal.fire('Deleted!', 'Holiday has been deleted.', 'success');
                    }
                });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.superadminapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\induspro\resources\views/superadmin/employee/holiday.blade.php ENDPATH**/ ?>