@extends('layouts.dashboard.superadminapp')

@section('title', 'Purchase Quotation Details')

@section('styles')
<style>
    .detail-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .detail-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .detail-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .detail-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .detail-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .detail-card .card-header.bg-secondary-gradient {
        background: linear-gradient(135deg, #858796 0%, #60616f 100%);
    }
    .detail-row {
        display: flex;
        padding: 0.5rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #5a5c69;
        min-width: 160px;
        font-size: 0.85rem;
    }
    .detail-value {
        color: #2e2e2e;
        font-size: 0.85rem;
        word-break: break-word;
    }
    .quotation-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    .info-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        height: 100%;
    }
    .info-card-title {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    .info-card-value {
        font-size: 1rem;
        font-weight: 600;
        color: #2e2e2e;
    }
    .items-table {
        font-size: 0.85rem;
    }
    .items-table th {
        background: #f8f9fc;
        font-weight: 600;
        font-size: 0.8rem;
        white-space: nowrap;
    }
    .file-link {
        display: inline-block;
        padding: 0.35rem 0.75rem;
        background: #e3e6f0;
        border-radius: 0.35rem;
        color: #4e73df;
        text-decoration: none;
        font-size: 0.8rem;
        margin: 0.25rem;
        transition: all 0.2s;
    }
    .file-link:hover {
        background: #4e73df;
        color: white;
        text-decoration: none;
    }
    .totals-row {
        display: flex;
        justify-content: space-between;
        padding: 0.5rem 0;
        border-bottom: 1px solid #e3e6f0;
    }
    .totals-row:last-child {
        border-bottom: none;
        font-weight: 700;
        font-size: 1.1rem;
        color: #1cc88a;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Purchase Quotation Details</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Quotation Header Card -->
    <div class="quotation-header">
        <div class="row align-items-center">
            <div class="col">
                <h3 class="mb-1">{{ $quotation->quotation_no }}</h3>
                <p class="mb-1 opacity-75">{{ $quotation->vendor_name }}</p>
                <div class="d-flex flex-wrap align-items-center mt-2">
                    @if ($quotation->status == 'approved')
                        <span class="badge badge-light mr-2"><i class="fas fa-check-circle mr-1 text-success"></i> Approved</span>
                    @elseif ($quotation->status == 'rejected')
                        <span class="badge badge-light mr-2"><i class="fas fa-times-circle mr-1 text-danger"></i> Rejected</span>
                    @else
                        <span class="badge badge-light mr-2"><i class="fas fa-clock mr-1 text-warning"></i> Pending</span>
                    @endif
                    <span class="badge badge-light"><i class="fas fa-calendar mr-1"></i> {{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d M Y') }}</span>
                </div>
            </div>
            <div class="col-auto">
                <a href="{{ route('superadmin.purchasequotation.index', ['id' => $quotation->id]) }}" class="btn btn-light btn-sm mr-2">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.purchasequotation.list') }}" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-building mr-1"></i> Vendor</div>
                <div class="info-card-value">{{ $quotation->vendor_name ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-file-alt mr-1"></i> RFQ No</div>
                <div class="info-card-value">{{ $quotation->rfq_no ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-list mr-1"></i> Items</div>
                <div class="info-card-value">{{ $quotation->items->count() }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-rupee-sign mr-1"></i> Grand Total</div>
                <div class="info-card-value">{{ number_format($quotation->grand_total, 2) }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Quotation Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-file-invoice mr-2"></i> Quotation Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Quotation No</span>
                        <span class="detail-value"><strong>{{ $quotation->quotation_no }}</strong></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Quotation Date</span>
                        <span class="detail-value">{{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d-m-Y') }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ No</span>
                        <span class="detail-value">{{ $quotation->rfq_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ Date</span>
                        <span class="detail-value">{{ $quotation->rfq_date ? \Carbon\Carbon::parse($quotation->rfq_date)->format('d-m-Y') : '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Vendor Ref No</span>
                        <span class="detail-value">{{ $quotation->vendor_reference_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Delivery Terms</span>
                        <span class="detail-value">{{ $quotation->delivery_terms ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Status</span>
                        <span class="detail-value">
                            @if ($quotation->status == 'approved')
                                <span class="badge badge-success">Approved</span>
                            @elseif ($quotation->status == 'rejected')
                                <span class="badge badge-danger">Rejected</span>
                            @else
                                <span class="badge badge-warning">Pending</span>
                            @endif
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Vendor Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header bg-info-gradient">
                    <i class="fas fa-building mr-2"></i> Vendor Details
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Vendor Name</span>
                        <span class="detail-value">{{ $quotation->vendor_name }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Address</span>
                        <span class="detail-value">{{ $quotation->address ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">GST</span>
                        <span class="detail-value"><code>{{ $quotation->gst ?: '-' }}</code></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Contact</span>
                        <span class="detail-value">{{ $quotation->phone ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Email</span>
                        <span class="detail-value">
                            @if($quotation->email)
                                <a href="mailto:{{ $quotation->email }}">{{ $quotation->email }}</a>
                            @else
                                -
                            @endif
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Notes & Description -->
    @if($quotation->note || $quotation->description)
    <div class="row">
        @if($quotation->note)
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header bg-warning-gradient">
                    <i class="fas fa-sticky-note mr-2"></i> Notes
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $quotation->note }}</p>
                </div>
            </div>
        </div>
        @endif
        @if($quotation->description)
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header bg-secondary-gradient">
                    <i class="fas fa-info-circle mr-2"></i> Description
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $quotation->description }}</p>
                </div>
            </div>
        </div>
        @endif
    </div>
    @endif

    <!-- Quotation Items -->
    <div class="card detail-card mb-4">
        <div class="card-header bg-success-gradient">
            <i class="fas fa-list mr-2"></i> Quotation Items
        </div>
        <div class="card-body">
            @if($quotation->items->count())
                <div class="table-responsive">
                    <table class="table table-bordered table-hover items-table">
                        <thead>
                            <tr class="text-center">
                                <th>#</th>
                                <th>Stock Item</th>
                                <th>Description</th>
                                <th>Qty</th>
                                <th>UOM</th>
                                <th>Unit Rate</th>
                                <th>Discount %</th>
                                <th>Value</th>
                                <th>SGST %</th>
                                <th>CGST %</th>
                                <th>IGST %</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($quotation->items as $index => $item)
                                <tr>
                                    <td class="text-center">{{ $index + 1 }}</td>
                                    <td>{{ $item->stockItem->item_name ?? $item->stock_item_name ?? '-' }}</td>
                                    <td>{{ $item->description ?: '-' }}</td>
                                    <td class="text-center">{{ $item->quantity }}</td>
                                    <td class="text-center">{{ $item->uom }}</td>
                                    <td class="text-right">{{ number_format($item->unit_rate, 2) }}</td>
                                    <td class="text-center">{{ $item->discount }}%</td>
                                    <td class="text-right">{{ number_format($item->value, 2) }}</td>
                                    <td class="text-center">{{ $item->sgst }}%</td>
                                    <td class="text-center">{{ $item->cgst }}%</td>
                                    <td class="text-center">{{ $item->igst }}%</td>
                                    <td class="text-right"><strong>{{ number_format($item->amount, 2) }}</strong></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No items found</p>
            @endif
        </div>
    </div>

    <!-- Summary & Totals -->
    <div class="row">
        <div class="col-lg-6 mb-4">
            <!-- Attachments -->
            <div class="card detail-card h-100">
                <div class="card-header bg-secondary-gradient">
                    <i class="fas fa-paperclip mr-2"></i> Attachments
                </div>
                <div class="card-body">
                    @if($quotation->files->count())
                        @foreach($quotation->files as $file)
                            <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank" class="file-link">
                                <i class="fas fa-external-link-alt mr-1"></i>
                                {{ $file->file_name }}
                            </a>
                        @endforeach
                    @else
                        <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No attachments</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-calculator mr-2"></i> Quotation Summary
                </div>
                <div class="card-body">
                    <div class="totals-row">
                        <span>Sub Total</span>
                        <span>{{ number_format($quotation->sub_total, 2) }}</span>
                    </div>
                    @if($quotation->discount > 0)
                    <div class="totals-row">
                        <span>Total Discount</span>
                        <span>-{{ number_format($quotation->discount, 2) }}</span>
                    </div>
                    @endif
                    @if($quotation->additional_charges > 0)
                    <div class="totals-row">
                        <span>Additional Charges</span>
                        <span>+{{ number_format($quotation->additional_charges, 2) }}</span>
                    </div>
                    @endif
                    @if($quotation->round_up != 0)
                    <div class="totals-row">
                        <span>Round Up</span>
                        <span>{{ number_format($quotation->round_up, 2) }}</span>
                    </div>
                    @endif
                    <div class="totals-row">
                        <span>Grand Total (INR)</span>
                        <span>{{ number_format($quotation->grand_total, 2) }}</span>
                    </div>
                    @if($quotation->inr_in_words)
                    <div class="mt-3 p-2 bg-light rounded">
                        <small class="text-muted">In Words:</small><br>
                        <strong>{{ $quotation->inr_in_words }}</strong>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-between mb-4">
        <a href="{{ route('superadmin.purchasequotation.list') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <div>
            @if($quotation->status === 'pending')
                <a href="{{ route('superadmin.purchasequotation.approve', $quotation->id) }}" class="btn btn-success mr-2">
                    <i class="fas fa-check mr-1"></i> Approve
                </a>
                <a href="{{ route('superadmin.purchasequotation.reject', $quotation->id) }}" class="btn btn-danger mr-2">
                    <i class="fas fa-times mr-1"></i> Reject
                </a>
            @endif
            <a href="{{ route('superadmin.purchasequotation.index', ['id' => $quotation->id]) }}" class="btn btn-primary">
                <i class="fas fa-edit mr-1"></i> Edit Quotation
            </a>
        </div>
    </div>
@endsection
