@extends('layouts.dashboard.superadminapp')

@section('title', 'Purchase Order Details')

@section('content')
    <style>
        .quotation-view-card {
            background: linear-gradient(120deg, #f6f7f9 0%, #e9ecef 100%);
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            border: none;
        }

        .quotation-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .quotation-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .quotation-body {
            background: #fff;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .quotation-label {
            color: #4f4f4f;
            font-weight: 600;
            display: block;
            margin-bottom: 0.3rem;
        }

        .quotation-value {
            color: #2b2b2b;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .quotation-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        .attachments-section {
            border: 1px solid #dee2e6;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .file-attachment {
            border: 1px solid #dee2e6;
            border-radius: 0.5rem;
            padding: 0.75rem;
            display: flex;
            align-items: center;
            margin-right: 0.75rem;
            margin-bottom: 0.75rem;
        }

        @media (max-width: 991px) {
            .quotation-body {
                padding: 1.2rem;
            }

            .quotation-header {
                padding: 1rem;
                flex-direction: column;
                align-items: flex-start;
            }
            
            .quotation-header .btn {
                margin-top: 1rem;
                align-self: flex-end;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-10">
                <div class="card quotation-view-card">
                    <div class="quotation-header">
                        <h3><i class="fas fa-file-invoice-dollar"></i> Purchase Invoice Details</h3>
                        <div>
                            <!--<a href="{{ route('superadmin.purchase.v1.print', $purchase->id) }}" -->
                            <!--   class="btn btn-light quotation-back-btn me-2" target="_blank">-->
                            <!--    <i class="fas fa-print me-1"></i> Print-->
                            <!--</a>-->
                            <a href="{{ route('superadmin.purchase.v1.index') }}" 
                               class="btn btn-light quotation-back-btn">
                                <i class="fas fa-arrow-left me-1"></i> Back
                            </a>
                        </div>
                    </div>
                    <div class="quotation-body">
                        <div class="row">
                            <div class="col-md-6">
                                <span class="quotation-label">Vendor Invoice No:</span>
                                <div class="quotation-value">{{ $purchase->vendor_invoice_no ?? '-' }}</div>
                                
                                <span class="quotation-label">Purchase Invoice No:</span>
                                <div class="quotation-value">{{ $purchase->purchase_no ?? '-' }}</div>
                                
                                <span class="quotation-label">Purchase Date:</span>
                                <div class="quotation-value">{{ $purchase->purchase_date ? \Carbon\Carbon::parse($purchase->purchase_date)->format('d/m/Y') : '-' }}</div>
                                
                                <span class="quotation-label">Purchase Order No:</span>
                                <div class="quotation-value">{{ $purchase->purchase_order_no ?? '-' }}</div>
                                
                                <span class="quotation-label">Purchase Order Date:</span>
                                <div class="quotation-value">{{ $purchase->purchase_order_date ? \Carbon\Carbon::parse($purchase->purchase_order_date)->format('d/m/Y') : '-' }}</div>
                                
                                <!--<span class="quotation-label">Quotation No:</span>-->
                                <!--<div class="quotation-value">{{ $purchase->quotation_no ?? '-' }}</div>-->
                                
                                <!--<span class="quotation-label">Quotation Date:</span>-->
                                <!--<div class="quotation-value">{{ $purchase->quotation_date ? \Carbon\Carbon::parse($purchase->quotation_date)->format('d/m/Y') : '-' }}</div>-->
                                
                                <span class="quotation-label d-none">Vendor:</span>
                                <div class="quotation-value d-none">{{ $purchase->company_name ?? '-' }}</div>
                                
                                <span class="quotation-label">Vendor Ref No:</span>
                                <div class="quotation-value">{{ $purchase->vendor_ref_no ?? '-' }}</div>
                                
                                <span class="quotation-label">Vendor GSTN:</span>
                                <div class="quotation-value">{{ $purchase->company_gstn ?? '-' }}</div>
                                
                                <span class="quotation-label">Vendor Phone:</span>
                                <div class="quotation-value">{{ $purchase->company_phone ?? '-' }}</div>
                                
                                <span class="quotation-label">Vendor Email:</span>
                                <div class="quotation-value">{{ $purchase->company_email ?? '-' }}</div>
                                
                                <span class="quotation-label ">Billing Address:</span>
                                <div class="quotation-value">{{ $purchase->bill_address ?? '-' }}</div>
                                
                                <span class="quotation-label d-none">Shipping Address:</span>
                                <div class="quotation-value d-none">{{ $purchase->ship_address ?? '-' }}</div>
                            </div>
                            
                            <div class="col-md-6">
                                <span class="quotation-label">Status:</span>
                                <div class="quotation-value">
                                    @php
                                        $status = $purchase->status ?? 'pending';
                                        $statusClass = 'badge-secondary';
                                        switch ($status) {
                                            case 'approved': $statusClass = 'badge-success'; break;
                                            case 'rejected': $statusClass = 'badge-danger'; break;
                                            case 'pending': default: $statusClass = 'badge-warning'; break;
                                        }
                                    @endphp
                                    <span class="badge {{ $statusClass }}">{{ ucfirst($status) }}</span>
                                </div>
                                
                                <span class="quotation-label">Payment Terms:</span>
                                <div class="quotation-value">{{ ucfirst($purchase->payment_terms ?? '-') }}</div>
                                
                                <span class="quotation-label">Payment Status:</span>
                                <div class="quotation-value">{{ ucfirst($purchase->payment_status ?? 'unpaid') }}</div>
                                
                                <span class="quotation-label">Payment Method:</span>
                                <div class="quotation-value">{{ $purchase->payment_method ?? '-' }}</div>
                                
                                <span class="quotation-label">Payment Reference No:</span>
                                <div class="quotation-value">{{ $purchase->payment_reference_no ?? '-' }}</div>
                                
                                <span class="quotation-label">Payment Delay Reason:</span>
                                <div class="quotation-value">{{ $purchase->payment_delay_reason ?? '-' }}</div>
                                
                                <span class="quotation-label">Description:</span>
                                <div class="quotation-value">{{ $purchase->description ?? '-' }}</div>
                                
                                <span class="quotation-label">Delivery Terms:</span>
                                <div class="quotation-value">{{ $purchase->delivery_terms ?? '-' }}</div>
                                
                                <span class="quotation-label">Note:</span>
                                <div class="quotation-value">{{ $purchase->note ?? '-' }}</div>
                            </div>
                        </div>

                        <div class="attachments-section mt-4">
                            <h5 class="mb-3"><i class="fas fa-paperclip me-2"></i> Attached Files</h5>
                            @if($purchase->files && count($purchase->files) > 0)
                                <div class="d-flex flex-wrap">
                                    @foreach($purchase->files as $file)
                                        <a href="{{ asset('storage/' . $file->file_path) }}" 
                                           target="_blank" 
                                           class="file-attachment">
                                            <i class="fas fa-file-alt me-2"></i> 
                                            <span class="text-dark" >{{ $file->file_name }}</span>
                                        </a>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-muted">No files attached.</p>
                            @endif
                        </div>

                        <h5 class="mb-3"><i class="fas fa-boxes me-2"></i> Items</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Item Name</th>
                                        <th>Description</th>
                                        <th>UOM</th>
                                        <th>Quantity</th>
                                        <th>Unit Rate</th>
                                        <th>Discount</th>
                                        <th>Value</th>
                                        <th>SGST</th>
                                        <th>CGST</th>
                                        <th>IGST</th>
                                        <th>TDS</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($purchase->items as $idx => $item)
                                        <tr>
                                            <td>{{ $idx + 1 }}</td>
                                            <td>{{ $item->stock_item_name ?? ($item->stockItem->name ?? '-') }}</td>
                                            <td>{{ $item->description ?? '-' }}</td>
                                            <td>{{ $item->uom ?? '-' }}</td>
                                            <td>{{ $item->quantity ?? 0 }}</td>
                                            <td>₹{{ number_format($item->unit_rate ?? 0, 2) }}</td>
                                            <td>{{ $item->discount ?? 0 }}%</td>
                                            <td>₹{{ number_format($item->value ?? 0, 2) }}</td>
                                            <td>{{ $item->sgst ?? 0 }}%</td>
                                            <td>{{ $item->cgst ?? 0 }}%</td>
                                            <td>{{ $item->igst ?? 0 }}%</td>
                                            <td>{{ $item->tds ?? 0 }}%</td>
                                            <td>₹{{ number_format($item->amount ?? 0, 2) }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="13" class="text-center">No items found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-6 offset-md-6">
                                <div class="border-top pt-3">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Subtotal:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->subtotal ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">SGST Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->sgst_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">CGST Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->cgst_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">IGST Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->igst_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Additional Charges:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->additional_charges ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">TDS Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->tds_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Net Payable Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->net_payable_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Grand Total:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->grand_total ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Paid Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->paid_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="quotation-label">Balance Amount:</span>
                                        <span class="quotation-value">₹{{ number_format($purchase->balance_amount ?? 0, 2) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <span class="quotation-label">Amount in Words:</span>
                                        <span class="quotation-value">{{ $purchase->inr_in_words ?? '-' }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Credit Notes Section -->
                        @if($purchase->creditNotes && count($purchase->creditNotes) > 0)
                        <div class="mt-4">
                            <h5 class="mb-3"><i class="fas fa-file-invoice me-2"></i> Associated Credit Notes</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Credit Note No</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Reason</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($purchase->creditNotes as $creditNote)
                                            <tr>
                                                <td>{{ $creditNote->credit_note_no }}</td>
                                                <td>{{ \Carbon\Carbon::parse($creditNote->date)->format('d/m/Y') }}</td>
                                                <td>₹{{ number_format($creditNote->amount, 2) }}</td>
                                                <td>{{ $creditNote->reason }}</td>
                                                <td>{{ $creditNote->description ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection