<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Vendor Payments</h5>
    <button class="btn btn-primary btn-sm" id="addPaymentBtn">
        <i class="fas fa-plus me-1"></i> Add Payment
    </button>
</div>

<div class="filter-section mb-3">
    <div class="row">
        <div class="col-md-3">
            <label class="form-label">Date Range</label>
            <input type="text" class="form-control payment-date-range" id="payment-date-range"
                placeholder="Select date range" autocomplete="off">
        </div>
        <div class="col-md-3">
            <label class="form-label">Vendor</label>
            <select class="form-control form-select" id="payment-party">
                <option value="">All Vendors</option>
                @foreach ($vendors ?? [] as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2">
            <label class="form-label">Min Amount</label>
            <input type="number" class="form-control" id="min-amount" placeholder="Min Amount" step="0.01">
        </div>
        <div class="col-md-2">
            <label class="form-label">Max Amount</label>
            <input type="number" class="form-control" id="max-amount" placeholder="Max Amount" step="0.01">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-primary me-2" id="applyPaymentFilters">
                <i class="fas fa-filter me-1"></i> Apply
            </button>
            <button class="btn btn-outline-secondary" id="resetPaymentFilters">
                <i class="fas fa-undo me-1"></i> Reset
            </button>
        </div>
    </div>
</div>

<div class="table-responsive">
    <table id="paymentTable" class="table table-bordered table-striped w-100">
        <thead>
            <tr>
                <th>Payment ID</th>
                <th>Purchase No</th>
                <th>Purchase Date</th>
                <th>Vendor</th>
                <th>Invoice No</th>
                <th>Total Amount</th>
                <th>Paid Amount</th>
                <th>Balance</th>
                <th>Payment Status</th>
                <th>Payment Mode</th>
                <th>Reference</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data will be loaded here -->
        </tbody>
    </table>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentModalLabel">Add Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">x</button>
            </div>
            <form id="paymentForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_purchase_id" class="form-label">Purchase Invoice <span class="text-danger">*</span></label>
                                <select class="form-select" id="payment_purchase_id" name="purchase_id" required>
                                    <option value="">Select Purchase Invoice</option>
                                    <!-- Will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_date" class="form-label">Payment Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="payment_date" name="payment_date" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_amount" class="form-label">Payment Amount <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="payment_amount" name="payment_amount" step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_method" class="form-label">Payment Method <span class="text-danger">*</span></label>
                                <select class="form-select" id="payment_method" name="payment_method" required>
                                    <option value="">Select Payment Method</option>
                                    <option value="cash">Cash</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="upi">UPI</option>
                                    <option value="card">Card</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_reference" class="form-label">Reference No</label>
                                <input type="text" class="form-control" id="payment_reference" name="payment_reference_no">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_notes" class="form-label">Notes</label>
                                <textarea class="form-control" id="payment_notes" name="notes" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>