<style>
    .aging-header {
        background: linear-gradient(120deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 1rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    
    .aging-summary-cards {
        margin-bottom: 2rem;
    }
    
    .aging-summary-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 0.75rem;
        padding: 1.5rem;
        text-align: center;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    }
    
    .aging-summary-card.warning {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }
    
    .aging-summary-card.danger {
        background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);
        color: #333;
    }
    
    .aging-summary-card.success {
        background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
        color: #333;
    }
    
    .aging-summary-value {
        font-size: 2rem;
        font-weight: bold;
        margin-bottom: 0.5rem;
    }
    
    .aging-summary-label {
        font-size: 0.9rem;
        opacity: 0.9;
    }

    .chart-container {
        height: 350px;
        margin-bottom: 30px;
        background: white;
        border-radius: 0.5rem;
        padding: 1rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .filter-section {
        background: linear-gradient(120deg, #f6f7f9 0%, #e9ecef 100%);
        padding: 1.5rem;
        border-radius: 0.75rem;
        margin-bottom: 2rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    .aging-table-container {
        background: white;
        border-radius: 0.75rem;
        padding: 1.5rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .bucket-current { background-color: #d4edda !important; }
    .bucket-1-30 { background-color: #fff3cd !important; }
    .bucket-31-60 { background-color: #f8d7da !important; }
    .bucket-61-90 { background-color: #f5c6cb !important; }
    .bucket-over-90 { background-color: #f1b0b7 !important; }

    .detailed-view {
        margin-top: 1rem;
        background: #f8f9fa;
        border-radius: 0.5rem;
        padding: 1rem;
    }
</style>

<div class="aging-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h4 class="mb-1"><i class="fas fa-chart-line me-2"></i> Payable Aging Report</h4>
            <p class="mb-0">Track outstanding payments and aging analysis</p>
        </div>
        <div class="btn-group">
            <button class="btn btn-light btn-sm" id="refreshAgingReport">
                <i class="fas fa-sync-alt me-1"></i> Refresh
            </button>
            <div class="btn-group">
                <button class="btn btn-light btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="fas fa-download me-1"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item export-aging" href="#" data-format="csv">
                        <i class="fas fa-file-csv me-2"></i>CSV
                    </a></li>
                    <li><a class="dropdown-item export-aging" href="#" data-format="excel">
                        <i class="fas fa-file-excel me-2"></i>Excel
                    </a></li>
                    <li><a class="dropdown-item export-aging" href="#" data-format="pdf">
                        <i class="fas fa-file-pdf me-2"></i>PDF
                    </a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="aging-summary-cards">
    <div class="row" id="agingSummaryCards">
        <div class="col-md-3">
            <div class="aging-summary-card">
                <div class="aging-summary-value" id="totalOutstanding">₹0</div>
                <div class="aging-summary-label">Total Outstanding</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="aging-summary-card warning">
                <div class="aging-summary-value" id="overdueAmount">₹0</div>
                <div class="aging-summary-label">Overdue Amount</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="aging-summary-card danger">
                <div class="aging-summary-value" id="criticalOverdue">₹0</div>
                <div class="aging-summary-label">Critical (>90 Days)</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="aging-summary-card success">
                <div class="aging-summary-value" id="totalPaid">₹0</div>
                <div class="aging-summary-label">Paid(Last 30days)</div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-section">
    <div class="row">
        <div class="col-md-3">
            <label class="form-label fw-bold">As of Date</label>
            <input type="date" class="form-control" id="aging-as-of-date" 
                   value="{{ date('Y-m-d') }}">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Vendors</label>
            <select class="form-select" id="aging-party">
                <option value="">Select Vendor</option>
                @foreach ($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">Report Type</label>
            <select class="form-select" id="aging-report-type">
                <option value="summary">Summary View</option>
                <option value="detailed">Detailed View</option>
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button class="btn btn-primary me-2" id="applyAgingFilters">
                <i class="fas fa-filter me-1"></i> Apply Filters
            </button>
            <button class="btn btn-outline-secondary" id="resetAgingFilters">
                <i class="fas fa-undo me-1"></i> Reset
            </button>
        </div>
    </div>
</div>

<!-- Chart -->
<div class="chart-container">
    <canvas id="agingChart"></canvas>
</div>

<!-- Table -->
<div class="aging-table-container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Aging Analysis</h5>
        <div class="btn-group btn-group-sm">
            <button class="btn btn-outline-primary active" id="summaryViewBtn">Summary</button>
            <button class="btn btn-outline-primary" id="detailedViewBtn">Detailed</button>
        </div>
    </div>
    
    <div class="table-responsive">
        <table id="agingTable" class="table table-striped table-bordered" style="width:100%">
            <thead class="table-dark">
                <tr>
                    <th>Vendor</th>
                    <th class="text-center">Current</th>
                    <th class="text-center">1-30 Days</th>
                    <th class="text-center">31-60 Days</th>
                    <th class="text-center">61-90 Days</th>
                    <th class="text-center">>90 Days</th>
                    <th class="text-center">Total Due</th>
                    <th class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be loaded here -->
            </tbody>
            <tfoot id="agingTableFooter" class="table-warning">
                <!-- Totals row will be added here -->
            </tfoot>
        </table>
    </div>
</div>

<!-- Detailed View Modal -->
<div class="modal fade" id="detailedAgingModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detailed Aging - <span id="modalVendorName"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Vendor Invoice</th>
                                <th>Date</th>
                                <th>Days Overdue</th>
                                <th>Total Amount</th>
                                <th>Paid Amount</th>
                                <th>Balance</th>
                                <th>Bucket</th>
                            </tr>
                        </thead>
                        <tbody id="detailedInvoicesList">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
