@extends('layouts.dashboard.superadminapp')

@section('title', 'User Details')

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / User Management</h1>
        <div class="display-date">
            <span id="day">day</span>, <span id="daynum">00</span> <span id="month">month</span> <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalUsers">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Active Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800" id="activeUsers">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Super Admins</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800" id="superadminCount">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Inactive Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800" id="inactiveUsers">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-times fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Card Table -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span class="fw-bold"><i class="fas fa-table me-2"></i> Users Data</span>
            <button class="btn btn-primary btn-sm" id="addUserBtn" title="Add New User">
                <i class="fa fa-plus-square" aria-hidden="true"></i> Add User
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="userTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th width="5%">Sl.No</th>
                            <th width="18%">Name</th>
                            <th width="22%">Email</th>
                            <th width="12%">Role</th>
                            <th width="10%">Status</th>
                            <th width="15%">Created</th>
                            <th width="18%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Loaded by AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit User Modal -->
    <div class="modal fade" id="userModal" tabindex="-1" aria-labelledby="userModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form id="userForm">
                @csrf
                <input type="hidden" name="user_id" id="user_id">
                <div class="modal-content border-0 shadow">
                    <!-- Header -->
                    <div class="modal-header py-2 bg-primary">
                        <h6 class="modal-title text-white mb-0" id="userModalLabel">
                            <i class="fas fa-user-plus mr-2" id="modalIcon"></i>Add New User
                        </h6>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>

                    <div class="modal-body py-3 px-3">
                        <!-- Error Alert -->
                        <div id="formErrors" class="alert alert-danger py-2 d-none mb-2" role="alert">
                            <small><i class="fas fa-exclamation-triangle mr-1"></i><strong>Error:</strong></small>
                            <ul class="mb-0 pl-3 small" id="errorList"></ul>
                        </div>

                        <!-- Name & Email Row -->
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label class="small font-weight-bold mb-1">Name <span class="text-danger">*</span></label>
                                <input name="name" id="name" class="form-control form-control-sm" placeholder="Full name" required>
                            </div>
                            <div class="col-md-6 mb-2">
                                <label class="small font-weight-bold mb-1">Email <span class="text-danger">*</span></label>
                                <input name="email" id="email" type="email" class="form-control form-control-sm" placeholder="user@example.com" required>
                            </div>
                        </div>

                        <!-- Password Row -->
                        <div class="row">
                            <div class="col-12 mb-2">
                                <label class="small font-weight-bold mb-1">Password <span id="pass-req" class="text-danger">*</span></label>
                                <div class="input-group input-group-sm">
                                    <input name="password" id="password" type="password" class="form-control" placeholder="Min 8 characters">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary toggle-password" type="button">
                                            <i class="fas fa-eye fa-sm"></i>
                                        </button>
                                    </div>
                                </div>
                                <small class="text-muted" id="pass-hint" style="font-size: 11px;">Required for new users</small>
                            </div>
                        </div>

                        <!-- Role & Status Row -->
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label class="small font-weight-bold mb-1">Role <span class="text-danger">*</span></label>
                                <select name="role" id="role" class="form-control form-control-sm" required>
                                    <option value="">Select Role</option>
                                    <option value="superadmin">Super Admin</option>
                                    <option value="admin">Admin</option>
                                    <option value="manager">Manager</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-2">
                                <label class="small font-weight-bold mb-1">Status</label>
                                <select name="status" id="status" class="form-control form-control-sm">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer py-2 bg-light">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary btn-sm" id="saveUserBtn">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <span class="btn-text">Save</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteUserLabel"><i class="fas fa-exclamation-triangle"></i> Delete User</h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this user?</p>
                    <p class="mb-0"><strong id="deleteUserName"></strong></p>
                    <small class="text-muted">This action cannot be undone.</small>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Delete User</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var currentUserId = {{ auth()->id() }};
    var usersData = [];

    // Load users function
    function loadUsers() {
        // Destroy DataTable first if it exists
        if ($.fn.DataTable.isDataTable('#userTable')) {
            $('#userTable').DataTable().clear().destroy();
        }
        $('#userTable tbody').empty();

        $.get('{{ route('superadmin.users.list') }}', function(res) {
            usersData = res.data;
            let rows = '';

            $.each(res.data, function(i, user) {
                var isCurrentUser = user.id == currentUserId;

                // Role badge
                var roleBadges = {
                    'superadmin': '<span class="badge badge-danger">Super Admin</span>',
                    'admin': '<span class="badge badge-primary">Admin</span>',
                    'manager': '<span class="badge badge-info">Manager</span>'
                };
                var roleBadge = roleBadges[user.role] || user.role;

                // Status badge
                var statusBadge = user.status === 'active'
                    ? '<span class="badge badge-success">Active</span>'
                    : '<span class="badge badge-secondary">Inactive</span>';

                // Status toggle button (not for current user)
                var statusBtn = '';
                if (!isCurrentUser) {
                    var statusIcon = user.status === 'active' ? 'fa-toggle-on text-success' : 'fa-toggle-off text-secondary';
                    var statusTitle = user.status === 'active' ? 'Deactivate User' : 'Activate User';
                    statusBtn = `<button class="btn btn-sm btn-light toggleStatusBtn" title="${statusTitle}" data-id="${user.id}"><i class="fas ${statusIcon} fa-lg"></i></button>`;
                }

                // Delete button (disabled for current user)
                var deleteDisabled = isCurrentUser ? 'disabled' : '';
                var deleteTitle = isCurrentUser ? 'Cannot delete your own account' : 'Delete User';

                rows += `<tr class="text-center align-middle">
                    <td>${i + 1}</td>
                    <td class="text-left">${user.name}</td>
                    <td class="text-left">${user.email}</td>
                    <td>${roleBadge}</td>
                    <td>${statusBadge}</td>
                    <td>${user.created_at}</td>
                    <td>
                        <div class="btn-group" role="group">
                            <button class="btn btn-sm btn-info editUserBtn" title="Edit User"
                                data-id="${user.id}"
                                data-name="${user.name}"
                                data-email="${user.email}"
                                data-role="${user.role}"
                                data-status="${user.status}">
                                <i class="fas fa-edit"></i>
                            </button>
                            ${statusBtn}
                            <button class="btn btn-sm btn-danger deleteUserBtn" title="${deleteTitle}"
                                data-id="${user.id}"
                                data-name="${user.name}"
                                ${deleteDisabled}>
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    </td>
                </tr>`;
            });

            $('#userTable tbody').html(rows);
            updateSummaryCards();

            // Initialize DataTable
            $('#userTable').DataTable({
                pageLength: 10,
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                order: [],
                columnDefs: [
                    { orderable: false, targets: [6] }
                ]
            });
        }).fail(function(err) {
            console.error('Failed to load users:', err);
            showToast('error', 'Failed to load users. Please refresh the page.');
        });
    }

    // Initial load
    loadUsers();

    // Update summary cards
    function updateSummaryCards() {
        var total = usersData.length;
        var active = usersData.filter(u => u.status === 'active').length;
        var inactive = usersData.filter(u => u.status === 'inactive').length;
        var superadmins = usersData.filter(u => u.role === 'superadmin').length;

        $('#totalUsers').text(total);
        $('#activeUsers').text(active);
        $('#inactiveUsers').text(inactive);
        $('#superadminCount').text(superadmins);
    }

    // Toggle password visibility
    $('.toggle-password').on('click', function() {
        var input = $(this).closest('.input-group').find('input');
        var icon = $(this).find('i');
        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            input.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });

    // Reset form and show modal for adding
    $('#addUserBtn').on('click', function() {
        $('#userForm')[0].reset();
        $('#user_id').val('');
        $('#formErrors').addClass('d-none');
        $('#modalIcon').removeClass('fa-user-edit').addClass('fa-user-plus');
        $('#userModalLabel').html('<i class="fas fa-user-plus mr-2" id="modalIcon"></i>Add New User');
        $('#pass-req').show();
        $('#pass-hint').text('Required for new users');
        $('#password').attr('required', true);
        $('#status').val('active');
        $('#userModal').modal('show');
    });

    // Edit User - populate form
    $('#userTable').on('click', '.editUserBtn', function() {
        $('#userForm')[0].reset();
        $('#formErrors').addClass('d-none');

        $('#user_id').val($(this).data('id'));
        $('#name').val($(this).data('name'));
        $('#email').val($(this).data('email'));
        $('#role').val($(this).data('role'));
        $('#status').val($(this).data('status') || 'active');

        $('#modalIcon').removeClass('fa-user-plus').addClass('fa-user-edit');
        $('#userModalLabel').html('<i class="fas fa-user-edit mr-2" id="modalIcon"></i>Edit User');
        $('#pass-req').hide();
        $('#pass-hint').text('Leave blank to keep current password');
        $('#password').attr('required', false);
        $('#userModal').modal('show');
    });

    // Save User (Add or Update)
    $('#userForm').submit(function(e) {
        e.preventDefault();

        var $btn = $('#saveUserBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        // Disable button and show spinner
        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Saving...');

        var user_id = $('#user_id').val();
        var url = user_id
            ? "{{ url('superadmin/users/update') }}/" + user_id
            : "{{ route('superadmin.users.store') }}";

        $.ajax({
            url: url,
            type: 'POST',
            data: $(this).serialize(),
            success: function(res) {
                $('#userModal').modal('hide');
                loadUsers();
                showToast('success', res.message || 'User saved successfully!');
            },
            error: function(err) {
                var errors = err.responseJSON?.errors || {};
                var message = err.responseJSON?.message || 'An error occurred';

                if (Object.keys(errors).length > 0) {
                    var errorHtml = '';
                    $.each(errors, function(field, messages) {
                        $.each(messages, function(i, msg) {
                            errorHtml += '<li>' + msg + '</li>';
                        });
                    });
                    $('#errorList').html(errorHtml);
                    $('#formErrors').removeClass('d-none');
                } else {
                    showToast('error', message);
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Save User');
            }
        });
    });

    // Toggle Status
    $('#userTable').on('click', '.toggleStatusBtn', function() {
        var userId = $(this).data('id');

        $.ajax({
            url: "{{ url('superadmin/users/toggle-status') }}/" + userId,
            type: 'POST',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(res) {
                loadUsers();
                showToast('success', res.message);
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'Failed to update status');
            }
        });
    });

    // Delete User - show confirmation
    var deleteUserId = null;
    $('#userTable').on('click', '.deleteUserBtn', function() {
        if ($(this).prop('disabled')) return;

        deleteUserId = $(this).data('id');
        $('#deleteUserName').text($(this).data('name'));
        $('#deleteUserModal').modal('show');
    });

    // Confirm Delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteUserId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: "{{ url('superadmin/users/delete') }}/" + deleteUserId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(res) {
                $('#deleteUserModal').modal('hide');
                loadUsers();
                showToast('success', res.message || 'User deleted successfully!');
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'Failed to delete user');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Delete User');
                deleteUserId = null;
            }
        });
    });

    // Toast notification helper
    function showToast(type, message) {
        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 250px;">
                <div class="toast-body d-flex align-items-center">
                    <i class="fas ${icon} mr-2"></i>
                    <span>${message}</span>
                    <button type="button" class="ml-auto close text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
