<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Payment Receipts</h6>
</div>

<!-- Filter Section -->
<div class="filter-card">
    <div class="row">
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Date Range</label>
            <input type="text" class="form-control form-control-sm receipts-date-range"
                placeholder="Select date range" readonly>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Customer</label>
            <select class="form-control form-control-sm" id="receipts-party">
                <option value="">All Customers</option>
                @foreach ($customers ?? [] as $customer)
                    <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Payment No</label>
            <input type="text" class="form-control form-control-sm receipts-filter"
                placeholder="Search by payment number">
        </div>
        <div class="col-md-3 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm mr-1" id="applyReceiptsFilters">
                <i class="fas fa-filter"></i> Apply
            </button>
            <button class="btn btn-secondary btn-sm" id="resetReceiptsFilters">
                <i class="fas fa-undo"></i> Reset
            </button>
        </div>
    </div>
</div>

<!-- Receipts Table -->
<div class="table-responsive">
    <table id="receiptsTable" class="table table-bordered table-striped table-sm w-100">
        <thead class="thead-light">
            <tr>
                <th>Receipt/Payment No</th>
                <th>Date</th>
                <th>Customer</th>
                <th>Invoice No</th>
                <th class="text-right">Amount</th>
                <th>Method</th>
                <th>Reference</th>
                <th class="text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data loaded via AJAX -->
        </tbody>
    </table>
</div>
