<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Customer Payments</h6>
    <button class="btn btn-primary btn-sm" id="addPaymentBtn">
        <i class="fas fa-plus mr-1"></i> Add Payment
    </button>
</div>

<!-- Filter Section -->
<div class="filter-card">
    <div class="row">
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Date Range</label>
            <input type="text" class="form-control form-control-sm" id="payment-date-range"
                placeholder="Select date range" autocomplete="off" readonly>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Customer</label>
            <select class="form-control form-control-sm" id="payment-party">
                <option value="">All Customers</option>
                @foreach ($customers ?? [] as $cust)
                    <option value="{{ $cust->id }}">{{ $cust->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2 mb-2">
            <label class="small font-weight-bold">Min Amount</label>
            <input type="number" class="form-control form-control-sm" id="min-amount" placeholder="Min" step="0.01">
        </div>
        <div class="col-md-2 mb-2">
            <label class="small font-weight-bold">Max Amount</label>
            <input type="number" class="form-control form-control-sm" id="max-amount" placeholder="Max" step="0.01">
        </div>
        <div class="col-md-2 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm mr-1" id="applyPaymentFilters">
                <i class="fas fa-filter"></i>
            </button>
            <button class="btn btn-secondary btn-sm" id="resetPaymentFilters">
                <i class="fas fa-undo"></i>
            </button>
        </div>
    </div>
</div>

<!-- Payments Table -->
<div class="table-responsive">
    <table id="paymentTable" class="table table-bordered table-striped table-sm w-100">
        <thead class="thead-light">
            <tr>
                <th>Payment ID</th>
                <th>Invoice No</th>
                <th>Invoice Date</th>
                <th>Customer</th>
                <th class="text-right">Total Amount</th>
                <th class="text-right">Paid Amount</th>
                <th class="text-right">Balance</th>
                <th>Status</th>
                <th>Payment Mode</th>
                <th>Reference</th>
                <th class="text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data loaded via AJAX -->
        </tbody>
    </table>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="paymentModalLabel">
                    <i class="fas fa-money-check-alt mr-2"></i> Add Payment
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="paymentForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Sales Invoice <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="payment_sales_id" name="sales_id" required>
                                    <option value="">Select Sales Invoice</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Payment Date <span class="text-danger">*</span>
                                </label>
                                <input type="date" class="form-control" id="payment_date" name="payment_date" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Payment Amount <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">₹</span>
                                    </div>
                                    <input type="number" class="form-control" id="payment_amount" name="payment_amount" step="0.01" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">
                                    Payment Method <span class="text-danger">*</span>
                                </label>
                                <select class="form-control" id="payment_method" name="payment_method" required>
                                    <option value="">Select Payment Method</option>
                                    <option value="cash">Cash</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="upi">UPI</option>
                                    <option value="card">Card</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">Reference No</label>
                                <input type="text" class="form-control" id="payment_reference" name="payment_reference_no" placeholder="e.g., Cheque No, UTR No">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="small font-weight-bold">Notes</label>
                                <textarea class="form-control" id="payment_notes" name="notes" rows="2" placeholder="Additional notes..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save mr-1"></i> Save Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
