<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Receivable Aging Report</h6>
    <div>
        <button class="btn btn-secondary btn-sm mr-1" id="refreshAgingReport">
            <i class="fas fa-sync-alt mr-1"></i> Refresh
        </button>
        <div class="btn-group">
            <button class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">
                <i class="fas fa-download mr-1"></i> Export
            </button>
            <div class="dropdown-menu dropdown-menu-right">
                <a class="dropdown-item export-aging" href="#" data-format="csv">
                    <i class="fas fa-file-csv mr-2"></i> CSV
                </a>
                <a class="dropdown-item export-aging" href="#" data-format="excel">
                    <i class="fas fa-file-excel mr-2"></i> Excel
                </a>
                <a class="dropdown-item export-aging" href="#" data-format="pdf">
                    <i class="fas fa-file-pdf mr-2"></i> PDF
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mb-4" id="agingSummaryCards">
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Receivable</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalReceivable">₹0</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Overdue Amount</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="overdueAmount">₹0</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card border-left-danger shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Critical (&gt;45 Days)</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="criticalOverdue">₹0</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-exclamation-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Received (Last 30 Days)</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800" id="totalReceived">₹0</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filter Section -->
<div class="filter-card">
    <div class="row">
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">As of Date</label>
            <input type="date" class="form-control form-control-sm" id="aging-as-of-date"
                   value="{{ date('Y-m-d') }}">
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Customer</label>
            <select class="form-control form-control-sm" id="aging-party">
                <option value="">All Customers</option>
                @foreach ($customers as $customer)
                    <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">Report Type</label>
            <select class="form-control form-control-sm" id="aging-report-type">
                <option value="summary">Summary View</option>
                <option value="detailed">Detailed View</option>
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm mr-1" id="applyAgingFilters">
                <i class="fas fa-filter"></i> Apply
            </button>
            <button class="btn btn-secondary btn-sm" id="resetAgingFilters">
                <i class="fas fa-undo"></i> Reset
            </button>
        </div>
    </div>
</div>

<!-- Chart -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Aging Distribution Chart</h6>
    </div>
    <div class="card-body">
        <div style="height: 300px;">
            <canvas id="agingChart"></canvas>
        </div>
    </div>
</div>

<!-- Table -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Aging Analysis</h6>
    <div class="btn-group btn-group-sm">
        <button class="btn btn-outline-primary active" id="summaryViewBtn">Summary</button>
        <button class="btn btn-outline-primary" id="detailedViewBtn">Detailed</button>
    </div>
</div>

<div class="table-responsive">
    <table id="agingTable" class="table table-bordered table-striped table-sm w-100">
        <thead class="thead-light">
            <tr>
                <th>Customer</th>
                <th class="text-center">Current</th>
                <th class="text-center">1-15 Days</th>
                <th class="text-center">16-30 Days</th>
                <th class="text-center">31-45 Days</th>
                <th class="text-center">&gt;45 Days</th>
                <th class="text-center">Total Due</th>
                <th class="text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data will be loaded here -->
        </tbody>
        <tfoot id="agingTableFooter" class="thead-light font-weight-bold">
            <!-- Totals row will be added here -->
        </tfoot>
    </table>
</div>

<!-- Detailed View Modal -->
<div class="modal fade" id="detailedAgingModal" tabindex="-1" aria-labelledby="detailedAgingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="detailedAgingModalLabel">
                    <i class="fas fa-list-alt mr-2"></i> Detailed Aging - <span id="modalVendorName"></span>
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-sm">
                        <thead class="thead-light">
                            <tr>
                                <th>Invoice No</th>
                                <th>Customer Invoice</th>
                                <th>Date</th>
                                <th class="text-center">Days Overdue</th>
                                <th class="text-right">Total Amount</th>
                                <th class="text-right">Paid Amount</th>
                                <th class="text-right">Balance</th>
                                <th class="text-center">Bucket</th>
                            </tr>
                        </thead>
                        <tbody id="detailedInvoicesList">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>
