@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Details')

@section('styles')
<style>
    .detail-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .detail-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .detail-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .detail-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .detail-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .detail-card .card-header.bg-secondary-gradient {
        background: linear-gradient(135deg, #858796 0%, #60616f 100%);
    }
    .detail-row {
        display: flex;
        padding: 0.5rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #5a5c69;
        min-width: 160px;
        font-size: 0.85rem;
    }
    .detail-value {
        color: #2e2e2e;
        font-size: 0.85rem;
        word-break: break-word;
    }
    .rfq-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    .info-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        height: 100%;
    }
    .info-card-title {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    .info-card-value {
        font-size: 1rem;
        font-weight: 600;
        color: #2e2e2e;
    }
    .file-link {
        display: inline-block;
        padding: 0.35rem 0.75rem;
        background: #e3e6f0;
        border-radius: 0.35rem;
        color: #4e73df;
        text-decoration: none;
        font-size: 0.8rem;
        margin: 0.25rem;
        transition: all 0.2s;
    }
    .file-link:hover {
        background: #4e73df;
        color: white;
        text-decoration: none;
    }
    .material-badge {
        display: inline-block;
        padding: 0.35rem 0.75rem;
        background: #e3e6f0;
        border-radius: 0.35rem;
        color: #5a5c69;
        font-size: 0.8rem;
        margin: 0.2rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | RFQ Details</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- RFQ Header Card -->
    <div class="rfq-header">
        <div class="row align-items-center">
            <div class="col">
                <h3 class="mb-1">{{ $rfq->rfq_no }}</h3>
                <p class="mb-1 opacity-75">{{ $rfq->customerInfo->company ?? 'N/A' }}</p>
                <div class="d-flex flex-wrap align-items-center mt-2">
                    @if ($rfq->status == 'approved')
                        <span class="badge badge-light mr-2"><i class="fas fa-check-circle mr-1 text-success"></i> Approved</span>
                    @elseif ($rfq->status == 'rejected')
                        <span class="badge badge-light mr-2"><i class="fas fa-times-circle mr-1 text-danger"></i> Rejected</span>
                    @else
                        <span class="badge badge-light mr-2"><i class="fas fa-clock mr-1 text-warning"></i> Pending</span>
                    @endif
                    <span class="badge badge-light"><i class="fas fa-calendar mr-1"></i> {{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d M Y') }}</span>
                </div>
            </div>
            <div class="col-auto">
                <a href="{{ route('superadmin.salesbom.rfq.edit', $rfq->id) }}" class="btn btn-light btn-sm mr-2">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-box mr-1"></i> RFQ Type</div>
                <div class="info-card-value">{{ $rfq->rfq_type ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-cube mr-1"></i> Product Type</div>
                <div class="info-card-value">{{ $rfq->product_type ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-hashtag mr-1"></i> Part No</div>
                <div class="info-card-value">{{ $rfq->part_no ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-layer-group mr-1"></i> Quantity</div>
                <div class="info-card-value">{{ $rfq->quantity }} {{ $rfq->uom }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- RFQ Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-file-alt mr-2"></i> RFQ Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">RFQ No</span>
                        <span class="detail-value"><strong>{{ $rfq->rfq_no }}</strong></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ Date</span>
                        <span class="detail-value">{{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d-m-Y') }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Customer</span>
                        <span class="detail-value">{{ $rfq->customerInfo->company ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Customer Ref No</span>
                        <span class="detail-value">{{ $rfq->cus_ref_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ Type</span>
                        <span class="detail-value">{{ $rfq->rfq_type ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Product Type</span>
                        <span class="detail-value">{{ $rfq->product_type ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Status</span>
                        <span class="detail-value">
                            @if ($rfq->status == 'approved')
                                <span class="badge badge-success">Approved</span>
                            @elseif ($rfq->status == 'rejected')
                                <span class="badge badge-danger">Rejected</span>
                            @else
                                <span class="badge badge-warning">Pending</span>
                            @endif
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header bg-info-gradient">
                    <i class="fas fa-cube mr-2"></i> Product Details
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Part No</span>
                        <span class="detail-value">{{ $rfq->part_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Project/Material No</span>
                        <span class="detail-value">{{ $rfq->project_material_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing No</span>
                        <span class="detail-value">{{ $rfq->drawing_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing Revision</span>
                        <span class="detail-value">{{ $rfq->drawing_rev ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Quantity</span>
                        <span class="detail-value"><strong>{{ $rfq->quantity }}</strong> {{ $rfq->uom }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Description</span>
                        <span class="detail-value">{{ $rfq->description ?: '-' }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Raw Materials Card -->
    <div class="card detail-card mb-4">
        <div class="card-header bg-success-gradient">
            <i class="fas fa-layer-group mr-2"></i> Raw Materials
        </div>
        <div class="card-body">
            @php
                $rawMaterials = json_decode($rfq->raw_material, true);
            @endphp
            @if (is_array($rawMaterials) && count($rawMaterials))
                <div class="d-flex flex-wrap">
                    @foreach ($rawMaterials as $matId)
                        <span class="material-badge">
                            <i class="fas fa-check-circle text-success mr-1"></i>
                            {{ $rawMaterialNames[$matId] ?? 'Unknown Material (ID: '.$matId.')' }}
                        </span>
                    @endforeach
                </div>
            @else
                <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No raw materials specified</p>
            @endif
        </div>
    </div>

    <!-- Note Card -->
    @if($rfq->note)
    <div class="card detail-card mb-4">
        <div class="card-header bg-warning-gradient">
            <i class="fas fa-sticky-note mr-2"></i> Notes
        </div>
        <div class="card-body">
            <p class="mb-0">{{ $rfq->note }}</p>
        </div>
    </div>
    @endif

    <!-- Attachments Card -->
    <div class="card detail-card mb-4">
        <div class="card-header bg-secondary-gradient">
            <i class="fas fa-paperclip mr-2"></i> Attachments
        </div>
        <div class="card-body">
            @php
                $fileTypes = [
                    'drawing' => ['label' => 'Drawing Files', 'icon' => 'fa-drafting-compass'],
                    'material_spec' => ['label' => 'Material Specification', 'icon' => 'fa-file-alt'],
                    'rfq_form' => ['label' => 'RFQ Form', 'icon' => 'fa-file-invoice'],
                    'annexure' => ['label' => 'Annexure', 'icon' => 'fa-file-archive']
                ];
                $hasFiles = false;
            @endphp

            <div class="row">
                @foreach ($fileTypes as $type => $info)
                    @php
                        $files = $rfq->rfqFiles->where('file_type', $type);
                    @endphp
                    @if ($files->count())
                        @php $hasFiles = true; @endphp
                        <div class="col-md-6 col-lg-3 mb-3">
                            <h6 class="font-weight-bold text-gray-700 mb-2">
                                <i class="fas {{ $info['icon'] }} mr-1"></i> {{ $info['label'] }}
                            </h6>
                            @foreach ($files as $file)
                                <a href="{{ '/induspro/public' . Storage::url($file->file_path) }}"
                                   target="_blank"
                                   class="file-link d-block"
                                   title="{{ $file->file_name }}">
                                   <i class="fas fa-external-link-alt mr-1"></i>
                                   {{ Str::limit($file->file_name, 20) }}
                                </a>
                            @endforeach
                        </div>
                    @endif
                @endforeach
            </div>

            @if(!$hasFiles)
                <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No attachments available</p>
            @endif
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-between mb-4">
        <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <a href="{{ route('superadmin.salesbom.rfq.edit', $rfq->id) }}" class="btn btn-primary">
            <i class="fas fa-edit mr-1"></i> Edit RFQ
        </a>
    </div>
@endsection
